/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.stats;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.stats.GlobalTransactionStats;

class GlobalTransactionStatsTest {
    private TransactionMonitor monitor1;
    private TransactionMonitor monitor2;
    private GlobalTransactionStats stats;

    GlobalTransactionStatsTest() {
    }

    @BeforeEach
    void setUp() {
        this.stats = new GlobalTransactionStats();
        this.monitor1 = this.stats.createDatabaseTransactionMonitor();
        this.monitor2 = this.stats.createDatabaseTransactionMonitor();
    }

    @Test
    void getNumberOfStartedTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        Assertions.assertEquals((long)3L, (long)this.stats.getNumberOfStartedTransactions());
    }

    @Test
    void getNumberOfCommittedTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionFinished(true, true);
        this.monitor1.transactionFinished(true, false);
        this.monitor2.transactionFinished(true, true);
        Assertions.assertEquals((long)3L, (long)this.stats.getNumberOfCommittedTransactions());
    }

    @Test
    void getNumberOfCommittedReadTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionFinished(true, true);
        this.monitor1.transactionFinished(true, false);
        this.monitor2.transactionFinished(true, true);
        Assertions.assertEquals((long)1L, (long)this.stats.getNumberOfCommittedReadTransactions());
    }

    @Test
    void getNumberOfCommittedWriteTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionFinished(true, true);
        this.monitor1.transactionFinished(false, true);
        this.monitor2.transactionFinished(true, true);
        Assertions.assertEquals((long)2L, (long)this.stats.getNumberOfCommittedWriteTransactions());
    }

    @Test
    void getNumberOfActiveTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor2.upgradeToWriteTransaction();
        Assertions.assertEquals((long)3L, (long)this.stats.getNumberOfActiveTransactions());
    }

    @Test
    void getNumberOfActiveReadTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        Assertions.assertEquals((long)3L, (long)this.stats.getNumberOfActiveReadTransactions());
    }

    @Test
    void getNumberOfActiveWriteTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.upgradeToWriteTransaction();
        this.monitor2.upgradeToWriteTransaction();
        Assertions.assertEquals((long)2L, (long)this.stats.getNumberOfActiveWriteTransactions());
    }

    @Test
    void getNumberOfTerminatedTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionTerminated(false);
        this.monitor1.transactionTerminated(true);
        this.monitor2.transactionTerminated(false);
        Assertions.assertEquals((long)3L, (long)this.stats.getNumberOfTerminatedTransactions());
    }

    @Test
    void getNumberOfTerminatedReadTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionTerminated(false);
        this.monitor1.transactionTerminated(true);
        this.monitor2.transactionTerminated(false);
        Assertions.assertEquals((long)2L, (long)this.stats.getNumberOfTerminatedReadTransactions());
    }

    @Test
    void getNumberOfTerminatedWriteTransactions() {
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionTerminated(true);
        this.monitor2.transactionTerminated(true);
        Assertions.assertEquals((long)2L, (long)this.stats.getNumberOfTerminatedWriteTransactions());
    }

    @Test
    void getNumberOfRolledBackTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionFinished(false, false);
        this.monitor1.transactionFinished(false, true);
        this.monitor2.transactionFinished(false, false);
        this.monitor2.transactionFinished(false, true);
        Assertions.assertEquals((long)4L, (long)this.stats.getNumberOfRolledBackTransactions());
    }

    @Test
    void getNumberOfRolledBackReadTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionFinished(false, false);
        this.monitor2.transactionFinished(false, false);
        Assertions.assertEquals((long)2L, (long)this.stats.getNumberOfRolledBackReadTransactions());
    }

    @Test
    void getNumberOfRolledBackWriteTransactions() {
        this.monitor1.transactionStarted();
        this.monitor1.transactionStarted();
        this.monitor2.transactionStarted();
        this.monitor1.transactionFinished(false, true);
        this.monitor1.transactionFinished(false, true);
        this.monitor2.transactionFinished(false, true);
        Assertions.assertEquals((long)3L, (long)this.stats.getNumberOfRolledBackWriteTransactions());
    }
}

