/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipTypeViewRelationshipStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;

class RelationshipTypeViewRelationshipStoreScanTest {
    private final StubStorageCursors cursors = new StubStorageCursors();
    private final RelationshipTypeScanStore relationshipTypeScanStore = (RelationshipTypeScanStore)Mockito.mock(RelationshipTypeScanStore.class);
    private final TokenScanReader relationshipTypeScanReader = (TokenScanReader)Mockito.mock(TokenScanReader.class);
    private final IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private final Visitor<EntityTokenUpdate, Exception> labelUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final Visitor<EntityUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);

    RelationshipTypeViewRelationshipStoreScanTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.relationshipTypeScanStore.newReader()).thenReturn((Object)this.relationshipTypeScanReader);
    }

    @Test
    void iterateOverRelationshipIds() {
        PrimitiveLongResourceIterator relationshipsWithType = PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L, 2L, 4L, 8L});
        long highId = 15L;
        for (long i = 0L; i < highId; ++i) {
            this.cursors.withRelationship(i, 1L, 0, 1L);
        }
        int[] types = new int[]{1};
        Mockito.when((Object)this.relationshipTypeScanReader.entitiesWithAnyOfTokens((int[])ArgumentMatchers.eq((Object)types), (PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)relationshipsWithType);
        RelationshipTypeViewRelationshipStoreScan<Exception> storeScan = this.getRelationshipTypeScanViewStoreScan(types);
        EntityIdIterator idIterator = storeScan.getEntityIdIterator();
        Assertions.assertThat((long)idIterator.next()).isEqualTo(1L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(2L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(4L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(8L);
        Assertions.assertThat((boolean)idIterator.hasNext()).isEqualTo(false);
    }

    private RelationshipTypeViewRelationshipStoreScan<Exception> getRelationshipTypeScanViewStoreScan(int[] relationshipTypeIds) {
        return new RelationshipTypeViewRelationshipStoreScan((StorageReader)this.cursors, LockService.NO_LOCK_SERVICE, this.relationshipTypeScanStore, this.labelUpdateVisitor, this.propertyUpdateVisitor, relationshipTypeIds, this.propertyKeyIdFilter, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }
}

