/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;

class DefaultIndexProviderMapTest {
    DefaultIndexProviderMapTest() {
    }

    @Test
    void shouldNotSupportMultipleProvidersWithSameDescriptor() {
        Dependencies dependencies = new Dependencies();
        IndexProvider provider = DefaultIndexProviderMapTest.provider("provider", "1.2");
        dependencies.satisfyDependency((Object)provider);
        dependencies.satisfyDependency((Object)DefaultIndexProviderMapTest.provider("provider", "1.2"));
        dependencies.satisfyDependency((Object)DefaultIndexProviderMapTest.fulltext());
        Assertions.assertThrows(IllegalArgumentException.class, () -> DefaultIndexProviderMapTest.createDefaultProviderMap(dependencies, provider.getProviderDescriptor()).init());
    }

    @Test
    void shouldThrowOnLookupOnUnknownProvider() {
        Dependencies dependencies = new Dependencies();
        IndexProvider provider = DefaultIndexProviderMapTest.provider("provider", "1.2");
        dependencies.satisfyDependency((Object)provider);
        dependencies.satisfyDependency((Object)DefaultIndexProviderMapTest.fulltext());
        DefaultIndexProviderMap defaultIndexProviderMap = DefaultIndexProviderMapTest.createDefaultProviderMap(dependencies, provider.getProviderDescriptor());
        defaultIndexProviderMap.init();
        Assertions.assertThrows(IndexProviderNotFoundException.class, () -> defaultIndexProviderMap.lookup(new IndexProviderDescriptor("provider2", "1.2")));
    }

    private static IndexProvider provider(String name, String version) {
        IndexProviderDescriptor descriptor = new IndexProviderDescriptor(name, version);
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)descriptor);
        return provider;
    }

    private static IndexProvider fulltext() {
        return DefaultIndexProviderMapTest.provider("fulltext", "1.0");
    }

    private static DefaultIndexProviderMap createDefaultProviderMap(Dependencies dependencies, IndexProviderDescriptor descriptor) {
        return new DefaultIndexProviderMap((DependencyResolver)dependencies, Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)descriptor.name()));
    }
}

