/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryTimespanThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

class LogPruneStrategyFactoryTest {
    private FileSystemAbstraction fsa;
    private SystemNanoClock clock;
    private AssertableLogProvider logProvider;

    LogPruneStrategyFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.fsa = new DefaultFileSystemAbstraction();
        this.clock = Clocks.nanoClock();
        this.logProvider = new AssertableLogProvider();
    }

    @Test
    void configuringFilesThreshold() {
        Threshold threshold = this.getThreshold(new ThresholdConfigParser.ThresholdConfigValue("files", 25L));
        Assertions.assertThat((Object)threshold).isInstanceOf(FileCountThreshold.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"25 files", (Object)threshold.toString());
    }

    @Test
    void configuringSizeThreshold() {
        Threshold threshold = this.getThreshold(new ThresholdConfigParser.ThresholdConfigValue("size", 16000L));
        Assertions.assertThat((Object)threshold).isInstanceOf(FileSizeThreshold.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"16000 size", (Object)threshold.toString());
    }

    @Test
    void configuringTxsThreshold() {
        Threshold threshold = this.getThreshold(new ThresholdConfigParser.ThresholdConfigValue("txs", 4000L));
        Assertions.assertThat((Object)threshold).isInstanceOf(EntryCountThreshold.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"4000 entries", (Object)threshold.toString());
    }

    @Test
    void configuringEntriesThreshold() {
        Threshold threshold = this.getThreshold(new ThresholdConfigParser.ThresholdConfigValue("entries", 4000L));
        Assertions.assertThat((Object)threshold).isInstanceOf(EntryCountThreshold.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"4000 entries", (Object)threshold.toString());
    }

    @Test
    void configuringHoursThreshold() {
        Threshold threshold = this.getThreshold(new ThresholdConfigParser.ThresholdConfigValue("hours", 100L));
        Assertions.assertThat((Object)threshold).isInstanceOf(EntryTimespanThreshold.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"100 hours", (Object)threshold.toString());
    }

    @Test
    void configuringDaysThreshold() {
        Threshold threshold = this.getThreshold(new ThresholdConfigParser.ThresholdConfigValue("days", 100000L));
        Assertions.assertThat((Object)threshold).isInstanceOf(EntryTimespanThreshold.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"100000 days", (Object)threshold.toString());
    }

    private Threshold getThreshold(ThresholdConfigParser.ThresholdConfigValue configValue) {
        return LogPruneStrategyFactory.getThresholdByType((FileSystemAbstraction)this.fsa, (LogProvider)this.logProvider, (SystemNanoClock)this.clock, (ThresholdConfigParser.ThresholdConfigValue)configValue, (String)"");
    }
}

