/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointerLifecycle;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;

class CheckpointerLifecycleTest {
    private final CheckPointer checkPointer = (CheckPointer)Mockito.mock(CheckPointer.class);
    private final Health databaseHealth = (Health)Mockito.mock(DatabaseHealth.class);
    private CheckpointerLifecycle checkpointLifecycle = new CheckpointerLifecycle(this.checkPointer, this.databaseHealth);

    CheckpointerLifecycleTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.databaseHealth.isHealthy()).thenReturn((Object)true);
    }

    @Test
    void checkpointOnShutdown() throws Throwable {
        this.checkpointLifecycle.shutdown();
        ((CheckPointer)Mockito.verify((Object)this.checkPointer)).forceCheckPoint((TriggerInfo)ArgumentMatchers.any(TriggerInfo.class));
    }

    @Test
    void skipCheckpointOnShutdownByRequest() throws Throwable {
        this.checkpointLifecycle.setCheckpointOnShutdown(false);
        this.checkpointLifecycle.shutdown();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.checkPointer});
    }
}

