/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.impl.security.URLAccessRules;

class FileURLAccessRuleTest {
    FileURLAccessRuleTest() {
    }

    @Test
    void shouldThrowWhenFileURLContainsAuthority() {
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)Config.defaults(), new URL("file://foo/bar/baz")));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("file URL may not contain an authority section (i.e. it should be 'file:///')");
    }

    @Test
    void shouldThrowWhenFileURLContainsQuery() {
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)Config.defaults(), new URL("file:///bar/baz?q=foo")));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("file URL may not contain a query component");
    }

    @Test
    void shouldThrowWhenFileAccessIsDisabled() throws Exception {
        URL url = new URL("file:///bar/baz.csv");
        Config config = Config.defaults((Setting)GraphDatabaseSettings.allow_file_urls, (Object)false);
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)config, url));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("configuration property 'dbms.security.allow_csv_import_from_file_urls' is false");
    }

    @Test
    void shouldThrowWhenRelativePathIsOutsideImportDirectory() {
        Assumptions.assumeFalse((boolean)Paths.get("/", new String[0]).relativize(Paths.get("/../baz.csv", new String[0])).toString().equals("baz.csv"));
        File importDir = new File("/tmp/neo4jtest").getAbsoluteFile();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.load_csv_file_url_root, (Object)importDir.toPath());
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)config, new URL("file:///../baz.csv")));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("file URL points outside configured import directory");
    }

    @Test
    void shouldAdjustURLToWithinImportDirectory() throws Exception {
        URL url = new File("/bar/baz.csv").toURI().toURL();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.load_csv_file_url_root, (Object)Path.of("/var/lib/neo4j/import", new String[0]));
        URL accessURL = URLAccessRules.fileAccess().validate((Configuration)config, url);
        URL expected = new File("/var/lib/neo4j/import/bar/baz.csv").toURI().toURL();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)accessURL);
    }
}

