/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

abstract class ActiveLocksListingCompatibility
extends LockCompatibilityTestSupport {
    ActiveLocksListingCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    void shouldListLocksHeldByTheCurrentClient() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L, 2L, 3L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L, 4L, 5L});
        Stream locks = this.clientA.activeLocks();
        Assertions.assertEquals(new HashSet<ActiveLock>(Arrays.asList(ActiveLock.exclusiveLock((ResourceType)ResourceTypes.NODE, (long)1L), ActiveLock.exclusiveLock((ResourceType)ResourceTypes.NODE, (long)2L), ActiveLock.exclusiveLock((ResourceType)ResourceTypes.NODE, (long)3L), ActiveLock.sharedLock((ResourceType)ResourceTypes.NODE, (long)3L), ActiveLock.sharedLock((ResourceType)ResourceTypes.NODE, (long)4L), ActiveLock.sharedLock((ResourceType)ResourceTypes.NODE, (long)5L))), locks.collect(Collectors.toSet()));
    }

    @Test
    void shouldCountNumberOfActiveLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{0L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{17L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{12L});
        long count = this.clientA.activeLockCount();
        Assertions.assertEquals((long)3L, (long)count);
    }
}

