/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

abstract class AcquireAndReleaseLocksCompatibility
extends LockCompatibilityTestSupport {
    AcquireAndReleaseLocksCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    void exclusiveShouldWaitForExclusive() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    void exclusiveShouldWaitForShared() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientC.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientC.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    void sharedShouldWaitForExclusive() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireShared(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    void shouldTrySharedLock() {
        Assertions.assertTrue((boolean)this.clientA.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    void shouldTryExclusiveLock() {
        Assertions.assertTrue((boolean)this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    void shouldTryUpgradeSharedToExclusive() {
        Assertions.assertTrue((boolean)this.clientA.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertTrue((boolean)this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    void shouldUpgradeExclusiveOnTry() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assertions.assertTrue((boolean)this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    void shouldAcquireMultipleSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertEquals((int)3, (int)this.lockCount());
    }

    @Test
    void shouldAcquireMultipleExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertEquals((int)3, (int)this.lockCount());
    }

    @Test
    void shouldAcquireMultipleAlreadyAcquiredSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assertions.assertEquals((int)4, (int)this.lockCount());
    }

    @Test
    void shouldAcquireMultipleAlreadyAcquiredExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assertions.assertEquals((int)4, (int)this.lockCount());
    }

    @Test
    void shouldAcquireMultipleSharedLocksWhileHavingSomeExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assertions.assertEquals((int)4, (int)this.lockCount());
    }

    @Test
    void shouldReleaseSharedLocksAcquiredInABatch() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L, 10L, 100L});
        Assertions.assertEquals((int)3, (int)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assertions.assertEquals((int)2, (int)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{10L});
        Assertions.assertEquals((int)1, (int)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L});
        Assertions.assertEquals((int)0, (int)this.lockCount());
    }

    @Test
    void shouldReleaseExclusiveLocksAcquiredInABatch() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L, 10L, 100L});
        Assertions.assertEquals((int)3, (int)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assertions.assertEquals((int)2, (int)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{10L});
        Assertions.assertEquals((int)1, (int)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{100L});
        Assertions.assertEquals((int)0, (int)this.lockCount());
    }

    @Test
    void releaseMultipleSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        Assertions.assertEquals((int)3, (int)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assertions.assertEquals((int)1, (int)this.lockCount());
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
    }

    @Test
    void releaseMultipleExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertEquals((int)3, (int)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{10L, 100L});
        Assertions.assertEquals((int)1, (int)this.lockCount());
        Assertions.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
    }

    @Test
    void releaseMultipleAlreadyAcquiredSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assertions.assertEquals((int)4, (int)this.lockCount());
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assertions.assertEquals((int)2, (int)this.lockCount());
    }

    @Test
    void releaseMultipleAlreadyAcquiredExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assertions.assertEquals((int)4, (int)this.lockCount());
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10000L));
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assertions.assertEquals((int)2, (int)this.lockCount());
    }

    @Test
    void releaseSharedLocksAcquiredSeparately() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        Assertions.assertEquals((int)3, (int)this.lockCount());
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 2L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 3L));
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L, 2L, 3L});
        Assertions.assertEquals((int)0, (int)this.lockCount());
        Assertions.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 2L));
        Assertions.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 3L));
    }

    @Test
    void releaseExclusiveLocksAcquiredSeparately() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        Assertions.assertEquals((int)3, (int)this.lockCount());
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 2L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 3L));
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L, 2L, 3L});
        Assertions.assertEquals((int)0, (int)this.lockCount());
        Assertions.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 2L));
        Assertions.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 3L));
    }

    @Test
    void releaseMultipleSharedLocksWhileHavingSomeExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assertions.assertEquals((int)4, (int)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assertions.assertEquals((int)4, (int)this.lockCount());
    }

    @Test
    void releaseMultipleExclusiveLocksWhileHavingSomeSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assertions.assertEquals((int)4, (int)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assertions.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assertions.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assertions.assertEquals((int)4, (int)this.lockCount());
    }

    private int lockCount() {
        LockCountVisitor lockVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockVisitor);
        return lockVisitor.getLockCount();
    }
}

