/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.RawBits;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class RawBitsTest {
    private static final IndexSpecificSpaceFillingCurveSettings specificSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    public GenericLayout layout = new GenericLayout(1, specificSettings);
    private final List<Object> objects = Arrays.asList(Double.NEGATIVE_INFINITY, -1.7976931348623157E308, Long.MIN_VALUE, -9223372036854775807L, Integer.MIN_VALUE, (short)Short.MIN_VALUE, (byte)-128, 0, Double.MIN_VALUE, Double.MIN_NORMAL, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MIN_NORMAL), 1L, 1.1, Float.valueOf(1.2f), Math.E, Math.PI, (byte)10, (short)20, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, 0x2000000, Float.valueOf(3.3554432E7f), 0x2000001, Float.valueOf(3.3554432E7f), 0x2000002, Float.valueOf(3.3554432E7f), 0x1FFFFFFFFFFFFFL, 9.007199254740991E15, 0x20000000000000L, 9.007199254740992E15, 0x20000000000001L, 9.007199254740992E15, 0x20000000000002L, 9.007199254740994E15, Long.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN, Math.nextDown(Math.E), Math.nextUp(Math.E), Math.nextDown(Math.PI), Math.nextUp(Math.PI));

    RawBitsTest() {
    }

    @Test
    void mustSortInSameOrderAsValueComparator() {
        List<Value> values = RawBitsTest.asValueObjects(this.objects);
        List<GenericKey> numberIndexKeys = this.asNumberIndexKeys(values);
        Collections.shuffle(values);
        Collections.shuffle(numberIndexKeys);
        values.sort((Comparator<Value>)Values.COMPARATOR);
        numberIndexKeys.sort((Comparator<GenericKey>)this.layout);
        List<Value> actual = RawBitsTest.asValues(numberIndexKeys);
        RawBitsTest.assertSameOrder(actual, values);
    }

    @Test
    void shouldCompareAllValuesToAllOtherValuesLikeValueComparator() {
        List<Value> values = RawBitsTest.asValueObjects(this.objects);
        List<GenericKey> numberIndexKeys = this.asNumberIndexKeys(values);
        values.sort((Comparator<Value>)Values.COMPARATOR);
        for (GenericKey genericKey : numberIndexKeys) {
            List<GenericKey> withoutThisOne = new ArrayList<GenericKey>(numberIndexKeys);
            Assertions.assertTrue((boolean)withoutThisOne.remove(genericKey));
            withoutThisOne = Collections.unmodifiableList(withoutThisOne);
            for (int i = 0; i < withoutThisOne.size(); ++i) {
                ArrayList<GenericKey> withThisOneInWrongPlace = new ArrayList<GenericKey>(withoutThisOne);
                withThisOneInWrongPlace.add(i, genericKey);
                withThisOneInWrongPlace.sort((Comparator<GenericKey>)this.layout);
                List<Value> actual = RawBitsTest.asValues(withThisOneInWrongPlace);
                RawBitsTest.assertSameOrder(actual, values);
            }
        }
    }

    @Test
    void shouldHaveSameCompareResultsAsValueCompare() {
        List<Value> values = RawBitsTest.asValueObjects(this.objects);
        List<GenericKey> numberIndexKeys = this.asNumberIndexKeys(values);
        for (int i = 0; i < values.size(); ++i) {
            Value value1 = values.get(i);
            GenericKey numberIndexKey1 = numberIndexKeys.get(i);
            for (int j = 0; j < values.size(); ++j) {
                Value value2 = values.get(j);
                GenericKey numberIndexKey2 = numberIndexKeys.get(j);
                Assertions.assertEquals((int)Values.COMPARATOR.compare(value1, value2), (int)this.layout.compare((NativeIndexKey)numberIndexKey1, (NativeIndexKey)numberIndexKey2));
                Assertions.assertEquals((int)Values.COMPARATOR.compare(value2, value1), (int)this.layout.compare((NativeIndexKey)numberIndexKey2, (NativeIndexKey)numberIndexKey1));
            }
        }
    }

    private static List<Value> asValues(List<GenericKey> numberIndexKeys) {
        return numberIndexKeys.stream().map(k -> RawBits.asNumberValue((long)k.long0, (byte)((byte)k.long1))).collect(Collectors.toList());
    }

    private static void assertSameOrder(List<Value> actual, List<Value> values) {
        Assertions.assertEquals((int)actual.size(), (int)values.size());
        for (int i = 0; i < actual.size(); ++i) {
            Number actualAsNumber = (Number)actual.get(i).asObject();
            Number valueAsNumber = (Number)values.get(i).asObject();
            if (Double.isNaN(actualAsNumber.doubleValue()) && Double.isNaN(valueAsNumber.doubleValue())) continue;
            Assertions.assertEquals((Object)actual.get(i), (Object)values.get(i));
        }
    }

    private static List<Value> asValueObjects(List<Object> objects) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (Object object : objects) {
            values.add(Values.of((Object)object));
        }
        return values;
    }

    private List<GenericKey> asNumberIndexKeys(List<Value> values) {
        ArrayList<GenericKey> numberIndexKeys = new ArrayList<GenericKey>();
        for (Value value : values) {
            GenericKey key = this.layout.newKey();
            key.initialize(0L);
            key.initFromValue(0, value, NativeIndexKey.Inclusion.NEUTRAL);
            numberIndexKeys.add(key);
        }
        return numberIndexKeys;
    }
}

