/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.Before;
import org.junit.Rule;
import org.junit.jupiter.api.Assertions;
import org.neo4j.configuration.Config;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.test.FormatCompatibilityVerifier;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class GenericKeyStateFormatTest
extends FormatCompatibilityVerifier {
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private static final int ENTITY_ID = 19570320;
    private static final int NUMBER_OF_SLOTS = 2;
    private List<Value> values;

    @Before
    public void setup() {
        this.values = new ArrayList<Value>();
        this.values.add((Value)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{ZonedDateTime.of(2018, 10, 9, 8, 7, 6, 5, ZoneId.of("UTC")), ZonedDateTime.of(2017, 9, 8, 7, 6, 5, 4, ZoneId.of("UTC"))}));
        this.values.add((Value)Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{LocalDateTime.of(2018, 10, 9, 8, 7, 6, 5), LocalDateTime.of(2018, 10, 9, 8, 7, 6, 5)}));
        this.values.add((Value)Values.dateArray((LocalDate[])new LocalDate[]{LocalDate.of(1, 12, 28), LocalDate.of(1, 12, 28)}));
        this.values.add((Value)Values.timeArray((OffsetTime[])new OffsetTime[]{OffsetTime.of(19, 8, 7, 6, ZoneOffset.UTC), OffsetTime.of(19, 8, 7, 6, ZoneOffset.UTC)}));
        this.values.add((Value)Values.localTimeArray((LocalTime[])new LocalTime[]{LocalTime.of(19, 28), LocalTime.of(19, 28)}));
        this.values.add((Value)Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((long)99L, (long)10L, (long)10L, (long)10L), DurationValue.duration((long)99L, (long)10L, (long)10L, (long)10L)}));
        this.values.add(Values.of((Object)new String[]{"someString1", "someString2"}));
        this.values.add(Values.of((Object)new boolean[]{true, true}));
        this.values.add(Values.of((Object)new byte[]{1, 12}));
        this.values.add(Values.of((Object)new short[]{314, 1337}));
        this.values.add(Values.of((Object)new int[]{3140, 13370}));
        this.values.add(Values.of((Object)new long[]{31400L, 133700L}));
        this.values.add(Values.of((Object)new float[]{0.5654f, 13432.14f}));
        this.values.add(Values.of((Object)new double[]{4.3245325443243E8, 4354.7888}));
        this.values.add(Values.of((Object)new char[]{'a', 'z'}));
        this.values.add((Value)DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"UTC"));
        this.values.add((Value)LocalDateTimeValue.localDateTime((int)2018, (int)3, (int)1, (int)13, (int)50, (int)42, (int)1337));
        this.values.add((Value)DateValue.epochDate((long)2L));
        this.values.add((Value)TimeValue.time((long)43200000000000L, (ZoneOffset)ZoneOffset.UTC));
        this.values.add((Value)LocalTimeValue.localTime((long)100000L));
        this.values.add((Value)DurationValue.duration((long)10L, (long)20L, (long)30L, (long)40L));
        this.values.add(Values.of((Object)"string1"));
        this.values.add(Values.of((Object)true));
        this.values.add(Values.of((Object)127));
        this.values.add(Values.of((Object)Short.MAX_VALUE));
        this.values.add(Values.of((Object)Integer.MAX_VALUE));
        this.values.add(Values.of((Object)Long.MAX_VALUE));
        this.values.add(Values.of((Object)Float.valueOf(Float.MAX_VALUE)));
        this.values.add(Values.of((Object)Double.MAX_VALUE));
        this.values.add(Values.of((Object)Character.valueOf('\uffff')));
        this.values.add((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.78, 56.7}));
        this.values.add((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.7566548, 56.7163465}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.13413478, 56.1343457})}));
        this.values.add((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.78, 56.7, 666.0}));
        this.values.add((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.7566548, 56.7163465, 666.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.13413478, 56.1343457, 555.0})}));
        this.values.add((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{4.3E-6, -1.2341025786543E-9}));
        this.values.add((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{4.3E-6, -1.2341025786543E-9}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.2000043, -0.03000000123410258})}));
        this.values.add((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{4.3E-6, -1.2341025786543E-9, 666.0}));
        this.values.add((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{4.3E-6, -1.2341025786543E-9, 666.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{0.2000043, -0.03000000123410258, 555.0})}));
    }

    protected String zipName() {
        return "current-generic-key-state-format.zip";
    }

    protected String storeFileName() {
        return "generic-key-state-store";
    }

    protected void createStoreFile(File storeFile) throws IOException {
        this.withCursor(storeFile, true, c -> {
            this.putFormatVersion((PageCursor)c);
            this.putData((PageCursor)c);
        });
    }

    protected void verifyFormat(File storeFile) throws FormatCompatibilityVerifier.FormatViolationException, IOException {
        AtomicReference exception = new AtomicReference();
        this.withCursor(storeFile, false, c -> {
            int major = c.getInt();
            int minor = c.getInt();
            GenericLayout layout = this.getLayout();
            if (major != layout.majorVersion() || minor != layout.minorVersion()) {
                exception.set(new FormatCompatibilityVerifier.FormatViolationException(String.format("Read format version %d.%d, but layout has version %d.%d", major, minor, layout.majorVersion(), layout.minorVersion())));
            }
        });
        if (exception.get() != null) {
            throw (FormatCompatibilityVerifier.FormatViolationException)exception.get();
        }
    }

    protected void verifyContent(File storeFile) throws IOException {
        this.withCursor(storeFile, false, c -> {
            this.readFormatVersion((PageCursor)c);
            this.verifyData((PageCursor)c);
        });
    }

    private void putFormatVersion(PageCursor cursor) {
        GenericLayout layout = this.getLayout();
        int major = layout.majorVersion();
        cursor.putInt(major);
        int minor = layout.minorVersion();
        cursor.putInt(minor);
    }

    private void readFormatVersion(PageCursor c) {
        c.getInt();
        c.getInt();
    }

    private void putData(PageCursor c) {
        GenericLayout layout = this.getLayout();
        GenericKey key = layout.newKey();
        for (Value value : this.values) {
            this.initializeFromValue(key, value);
            c.putInt(key.size());
            layout.writeKey(c, key);
        }
    }

    private void initializeFromValue(GenericKey key, Value value) {
        key.initialize(19570320L);
        for (int i = 0; i < 2; ++i) {
            key.initFromValue(i, value, NativeIndexKey.Inclusion.NEUTRAL);
        }
    }

    private void verifyData(PageCursor c) {
        GenericLayout layout = this.getLayout();
        GenericKey readCompositeKey = layout.newKey();
        GenericKey comparison = layout.newKey();
        for (Value value : this.values) {
            int keySize = c.getInt();
            layout.readKey(c, readCompositeKey, keySize);
            for (Value readValue : readCompositeKey.asValues()) {
                this.initializeFromValue(comparison, value);
                Assertions.assertEquals((int)0, (int)layout.compare((NativeIndexKey)readCompositeKey, (NativeIndexKey)comparison), (String)this.detailedFailureMessage(readCompositeKey, comparison));
                if (readValue == Values.NO_VALUE) continue;
                Assertions.assertEquals((Object)value, (Object)readValue, (String)("expected read value to be " + value + ", but was " + readValue));
            }
        }
    }

    private String detailedFailureMessage(GenericKey actualKey, GenericKey expectedKey) {
        return "expected " + expectedKey.toDetailedString() + ", but was " + actualKey.toDetailedString();
    }

    private GenericLayout getLayout() {
        return new GenericLayout(2, IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults()));
    }

    private void withCursor(File storeFile, boolean create, Consumer<PageCursor> cursorConsumer) throws IOException {
        ImmutableSet openOptions = create ? Sets.immutable.of((Object)StandardOpenOption.WRITE, (Object)StandardOpenOption.CREATE) : Sets.immutable.of((Object)StandardOpenOption.WRITE);
        try (PageCache pageCache = this.pageCacheRule.getPageCache(this.globalFs.get());
             PagedFile pagedFile = pageCache.map(storeFile, pageCache.pageSize(), openOptions);
             PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
            cursor.next();
            cursorConsumer.accept(cursor);
        }
    }
}

