/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.PathProxy;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

class PathProxyTest {
    private final InternalTransaction transaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);

    PathProxyTest() {
    }

    @Test
    void shouldIterateThroughNodes() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.nodes().iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        Node node = (Node)iterator.next();
        Assertions.assertThat((Object)node).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)node.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        Assertions.assertThat((Object)node).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)node.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        Assertions.assertThat((Object)node).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)node.getId());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldIterateThroughNodesInReverse() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.reverseNodes().iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        Node node = (Node)iterator.next();
        Assertions.assertThat((Object)node).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)node.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        Assertions.assertThat((Object)node).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)node.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        Assertions.assertThat((Object)node).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)node.getId());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldIterateThroughRelationships() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.relationships().iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        Relationship relationship = (Relationship)iterator.next();
        Assertions.assertThat((Object)relationship).isInstanceOf(Relationship.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)relationship.getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)relationship.getStartNodeId());
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)relationship.getEndNodeId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        relationship = (Relationship)iterator.next();
        Assertions.assertThat((Object)relationship).isInstanceOf(Relationship.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)200L, (long)relationship.getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)relationship.getStartNodeId());
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)relationship.getEndNodeId());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldIterateThroughRelationshipsInReverse() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.reverseRelationships().iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        Relationship relationship = (Relationship)iterator.next();
        Assertions.assertThat((Object)relationship).isInstanceOf(Relationship.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)200L, (long)relationship.getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)relationship.getStartNodeId());
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)relationship.getEndNodeId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        relationship = (Relationship)iterator.next();
        Assertions.assertThat((Object)relationship).isInstanceOf(Relationship.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)relationship.getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)relationship.getStartNodeId());
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)relationship.getEndNodeId());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldIterateAlternatingNodesAndRelationships() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        Entity entity = (Entity)iterator.next();
        Assertions.assertThat((Object)entity).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)entity.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        entity = (Entity)iterator.next();
        Assertions.assertThat((Object)entity).isInstanceOf(Relationship.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)entity.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        entity = (Entity)iterator.next();
        Assertions.assertThat((Object)entity).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)entity.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        entity = (Entity)iterator.next();
        Assertions.assertThat((Object)entity).isInstanceOf(Relationship.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)200L, (long)entity.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        entity = (Entity)iterator.next();
        Assertions.assertThat((Object)entity).isInstanceOf(Node.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)entity.getId());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

