/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.transaction.monitor.KernelTransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitorScheduler;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

class KernelTransactionMonitorSchedulerTest {
    private final JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final KernelTransactionMonitor transactionTimeoutMonitor = (KernelTransactionMonitor)Mockito.mock(KernelTransactionMonitor.class);

    KernelTransactionMonitorSchedulerTest() {
    }

    @Test
    void scheduleRecurringMonitorJobIfConfigured() {
        TransactionMonitorScheduler transactionMonitorScheduler = this.createMonitorScheduler(1L);
        transactionMonitorScheduler.start();
        ((JobScheduler)Mockito.verify((Object)this.scheduler)).scheduleRecurring(Group.TRANSACTION_TIMEOUT_MONITOR, (Runnable)this.transactionTimeoutMonitor, 1L, TimeUnit.MILLISECONDS);
    }

    @Test
    void doNotScheduleMonitorJobIfDisabled() {
        TransactionMonitorScheduler transactionMonitorScheduler = this.createMonitorScheduler(0L);
        transactionMonitorScheduler.start();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.scheduler});
    }

    private TransactionMonitorScheduler createMonitorScheduler(long checkInterval) {
        return new TransactionMonitorScheduler((TransactionMonitor)this.transactionTimeoutMonitor, this.scheduler, checkInterval);
    }
}

