/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;

class SchemaDescriptorTest {
    private static final int REL_TYPE_ID = 0;
    private static final int LABEL_ID = 0;

    SchemaDescriptorTest() {
    }

    @Test
    void shouldCreateLabelDescriptors() {
        LabelSchemaDescriptor labelDesc = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
        Assertions.assertThat((int)labelDesc.getLabelId()).isEqualTo(0);
        Assertions.assertThat((Comparable)labelDesc.entityType()).isEqualTo((Object)EntityType.NODE);
        Assertions.assertThat((Comparable)labelDesc.propertySchemaType()).isEqualTo((Object)PropertySchemaType.COMPLETE_ALL_TOKENS);
        SchemaTestUtil.assertArray(labelDesc.getPropertyIds(), 1);
        labelDesc = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1, 2, 3});
        Assertions.assertThat((int)labelDesc.getLabelId()).isEqualTo(0);
        SchemaTestUtil.assertArray(labelDesc.getPropertyIds(), 1, 2, 3);
    }

    @Test
    void shouldCreateRelTypeDescriptors() {
        RelationTypeSchemaDescriptor relTypeDesc = SchemaDescriptor.forRelType((int)0, (int[])new int[]{1});
        Assertions.assertThat((int)relTypeDesc.getRelTypeId()).isEqualTo(0);
        Assertions.assertThat((Comparable)relTypeDesc.entityType()).isEqualTo((Object)EntityType.RELATIONSHIP);
        Assertions.assertThat((Comparable)relTypeDesc.propertySchemaType()).isEqualTo((Object)PropertySchemaType.COMPLETE_ALL_TOKENS);
        SchemaTestUtil.assertArray(relTypeDesc.getPropertyIds(), 1);
        relTypeDesc = SchemaDescriptor.forRelType((int)0, (int[])new int[]{1, 2, 3});
        Assertions.assertThat((int)relTypeDesc.getRelTypeId()).isEqualTo(0);
        SchemaTestUtil.assertArray(relTypeDesc.getPropertyIds(), 1, 2, 3);
    }

    @Test
    void shouldCreateEqualLabels() {
        LabelSchemaDescriptor desc1 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
        LabelSchemaDescriptor desc2 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    void shouldCreateEqualRelTypes() {
        RelationTypeSchemaDescriptor desc1 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{1});
        RelationTypeSchemaDescriptor desc2 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    void shouldGiveNiceUserDescriptions() {
        Assertions.assertThat((String)SchemaDescriptor.forLabel((int)1, (int[])new int[]{2}).userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP)).isEqualTo("(:Label1 {property2})");
        Assertions.assertThat((String)SchemaDescriptor.forRelType((int)1, (int[])new int[]{3}).userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP)).isEqualTo("-[:RelType1 {property3}]-");
    }
}

