/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.token.TokenHolders;

class TransactionImplTest {
    private final TokenHolders tokenHolders = (TokenHolders)Mockito.mock(TokenHolders.class);
    private final QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private final TransactionalContextFactory contextFactory = (TransactionalContextFactory)Mockito.mock(TransactionalContextFactory.class);
    private final DatabaseAvailabilityGuard availabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);

    TransactionImplTest() {
    }

    @Test
    void shouldThrowTransientExceptionOnTransientKernelException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new TransactionFailureException((Status)Status.Transaction.ConstraintsChanged, "Proving that transaction does the right thing", new Object[0])}).when((Object)kernelTransaction)).close();
        TransactionImpl transaction = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        transaction.commit();
    }

    @Test
    void shouldThrowTransactionExceptionOnTransientKernelException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Just a random failure")}).when((Object)kernelTransaction)).close();
        TransactionImpl transaction = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        transaction.commit();
    }

    @Test
    void shouldLetThroughTransientFailureException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new TransientDatabaseFailureException("Just a random failure")}).when((Object)kernelTransaction)).close();
        TransactionImpl transaction = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        transaction.commit();
    }

    @Test
    void shouldShowTransactionTerminatedExceptionAsTransient() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        ((KernelTransaction)Mockito.doReturn((Object)true).when((Object)kernelTransaction)).isOpen();
        TransactionTerminatedException error = new TransactionTerminatedException((Status)Status.Transaction.Terminated);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)kernelTransaction)).close();
        TransactionImpl transaction = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        transaction.commit();
    }

    @Test
    void shouldReturnTerminationReason() {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.getReasonIfTerminated()).thenReturn(Optional.empty()).thenReturn(Optional.of(Status.Transaction.Terminated));
        TransactionImpl tx = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        Optional terminationReason1 = tx.terminationReason();
        Optional terminationReason2 = tx.terminationReason();
        Assertions.assertFalse((boolean)terminationReason1.isPresent());
        Assertions.assertTrue((boolean)terminationReason2.isPresent());
        Assertions.assertEquals((Object)Status.Transaction.Terminated, terminationReason2.get());
    }
}

