/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.Iterators;

class ArrayUtilTest {
    ArrayUtilTest() {
    }

    @Test
    void shouldProduceUnionOfTwoArrays() {
        Object[] first = new String[]{"one", "three"};
        Object[] other = new String[]{"two", "four", "five"};
        Object[] union = (String[])ArrayUtil.union((Object[])first, (Object[])other);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"one", "two", "three", "four", "five"}), (Object)Iterators.asSet((Object[])union));
    }

    @Test
    void shouldProduceUnionWhereFirstIsNull() {
        Object[] first = null;
        Object[] other = new String[]{"one", "two"};
        Object[] union = (String[])ArrayUtil.union(first, (Object[])other);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"one", "two"}), (Object)Iterators.asSet((Object[])union));
    }

    @Test
    void shouldProduceUnionWhereOtherIsNull() {
        Object[] first = new String[]{"one", "two"};
        Object[] other = null;
        Object[] union = (String[])ArrayUtil.union((Object[])first, other);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"one", "two"}), (Object)Iterators.asSet((Object[])union));
    }

    @Test
    void shouldCheckNullSafeEqual() {
        Assertions.assertTrue((boolean)ArrayUtil.nullSafeEquals(null, null));
        Assertions.assertFalse((boolean)ArrayUtil.nullSafeEquals((Object)"1", null));
        Assertions.assertFalse((boolean)ArrayUtil.nullSafeEquals(null, (Object)"1"));
        Assertions.assertTrue((boolean)ArrayUtil.nullSafeEquals((Object)"1", (Object)"1"));
    }

    @Test
    void shouldConcatOneAndMany() {
        Integer[] result = (Integer[])ArrayUtil.concat((Object)0, (Object[])new Integer[]{1, 2, 3, 4});
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)result[i]);
        }
    }

    @Test
    void shouldConcatSeveralArrays() {
        Object[] a = new Integer[]{0, 1, 2};
        Integer[] b = new Integer[]{3, 4};
        Integer[] c = new Integer[]{5, 6, 7, 8};
        Integer[] result = (Integer[])ArrayUtil.concatArrays((Object[])a, (Object[][])new Integer[][]{b, c});
        Assertions.assertEquals((int)(a.length + b.length + c.length), (int)result.length);
        for (int i = 0; i < result.length; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)result[i]);
        }
    }

    @Test
    void shouldFindIndexOf() {
        Object[] numbers = (Integer[])ArrayUtil.concat((Object)0, (Object[])new Integer[]{1, 2, 3, 4, 5});
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((int)i, (int)ArrayUtil.indexOf((Object[])numbers, (Object)i));
        }
    }

    @Test
    void shouldFindLastOf() {
        Object[] numbers = new Integer[]{0, 100, 4, 5, 6, 3};
        Assertions.assertEquals((int)3, (int)((Integer)ArrayUtil.lastOf((Object[])numbers)));
    }

    @Test
    void shouldRemoveItems() {
        Object[] numbers = (Integer[])ArrayUtil.concat((Object)0, (Object[])new Integer[]{1, 2, 3, 4, 5});
        Object[] trimmed = (Integer[])ArrayUtil.without((Object[])numbers, (Object[])new Integer[]{2});
        trimmed = (Integer[])ArrayUtil.without((Object[])trimmed, (Object[])new Integer[]{5});
        trimmed = (Integer[])ArrayUtil.without((Object[])trimmed, (Object[])new Integer[]{0});
        Assertions.assertEquals((int)3, (int)trimmed.length);
        Assertions.assertFalse((boolean)ArrayUtil.contains((Object[])trimmed, (Object)0));
        Assertions.assertTrue((boolean)ArrayUtil.contains((Object[])trimmed, (Object)1));
        Assertions.assertFalse((boolean)ArrayUtil.contains((Object[])trimmed, (Object)2));
        Assertions.assertTrue((boolean)ArrayUtil.contains((Object[])trimmed, (Object)3));
        Assertions.assertTrue((boolean)ArrayUtil.contains((Object[])trimmed, (Object)4));
        Assertions.assertFalse((boolean)ArrayUtil.contains((Object[])trimmed, (Object)5));
    }

    @Test
    void shouldConcatArrays() {
        Object[] initial = new Integer[]{0, 1, 2};
        Object[] all = (Integer[])ArrayUtil.concat((Object[])initial, (Object[])new Integer[]{3, 4, 5});
        Assertions.assertArrayEquals((Object[])new Integer[]{0, 1, 2, 3, 4, 5}, (Object[])all);
    }

    @Test
    void shouldReverseEvenCount() {
        Object[] array = new Integer[]{0, 1, 2, 3, 4, 5};
        ArrayUtil.reverse((Object[])array);
        Assertions.assertArrayEquals((Object[])new Integer[]{5, 4, 3, 2, 1, 0}, (Object[])array);
    }

    @Test
    void shouldReverseUnevenCount() {
        Object[] array = new Integer[]{0, 1, 2, 3, 4};
        ArrayUtil.reverse((Object[])array);
        Assertions.assertArrayEquals((Object[])new Integer[]{4, 3, 2, 1, 0}, (Object[])array);
    }

    @Test
    void shouldReverseEmptyArray() {
        Object[] array = new Integer[]{};
        ArrayUtil.reverse((Object[])array);
        Assertions.assertArrayEquals((Object[])new Integer[0], (Object[])array);
    }
}

