/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.dbms.database.DatabaseConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.test.Race;

class DatabaseConfigTest {
    DatabaseConfigTest() {
    }

    @Test
    void shouldHandleRegisterDynamicUpdateListenersConcurrently() throws Throwable {
        NamedDatabaseId namedDatabaseId = new TestDatabaseIdRepository().defaultDatabase();
        DatabaseConfig dbConfig = new DatabaseConfig(Config.defaults(), namedDatabaseId);
        Setting setting = GraphDatabaseSettings.transaction_tracing_level;
        int threads = 100;
        Listener[] listeners = new Listener[threads];
        for (int i = 0; i < threads; ++i) {
            listeners[i] = new Listener();
        }
        Race race = new Race();
        int i = 0;
        while (i < threads) {
            int slot = i++;
            race.addContestant(() -> dbConfig.addListener(setting, (SettingChangeListener)listeners[slot]), 1);
        }
        race.go();
        dbConfig.setDynamic(setting, (Object)GraphDatabaseSettings.TransactionTracingLevel.DISABLED, this.getClass().getSimpleName());
        for (i = 0; i < threads; ++i) {
            Assertions.assertEquals((int)1, (int)listeners[i].callCount);
        }
    }

    private static class Listener
    implements SettingChangeListener<GraphDatabaseSettings.TransactionTracingLevel> {
        private int callCount;

        private Listener() {
        }

        public void accept(GraphDatabaseSettings.TransactionTracingLevel from, GraphDatabaseSettings.TransactionTracingLevel to) {
            ++this.callCount;
        }
    }
}

