/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.assertj.core.api.Assertions;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.trackable.HeapTrackingLongIntHashMap;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingLongIntHashMapTest {
    private final MemoryMeter meter = new MemoryMeter();
    private MemoryPool memoryPool;
    private MemoryTracker memoryTracker;

    HeapTrackingLongIntHashMapTest() {
    }

    @BeforeEach
    void setUp() {
        this.memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null);
        this.memoryTracker = new LocalMemoryTracker(this.memoryPool);
    }

    @Test
    void calculateEmptySize() {
        HeapTrackingLongIntHashMap longIntHashMap = HeapTrackingLongIntHashMap.createLongIntHashMap((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation(longIntHashMap);
        longIntHashMap.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void reactToGrowth() {
        long totalBytesIntegers = 0L;
        HeapTrackingLongIntHashMap longObjectHashMap = HeapTrackingLongIntHashMap.createLongIntHashMap((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation(longObjectHashMap);
        long emptySize = this.memoryTracker.estimatedHeapMemory();
        for (int i = 2; i <= 10; ++i) {
            longObjectHashMap.put((long)i, i);
        }
        this.assertExactEstimation(longObjectHashMap);
        Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isGreaterThan(emptySize);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isGreaterThanOrEqualTo(this.memoryTracker.estimatedHeapMemory());
        longObjectHashMap.close();
        this.memoryTracker.releaseHeap(totalBytesIntegers);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.reset();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryPool.usedHeap());
    }

    private void assertExactEstimation(HeapTrackingLongIntHashMap longIntHashMap) {
        org.junit.jupiter.api.Assertions.assertEquals((long)(this.meter.measureDeep((Object)longIntHashMap) - this.meter.measureDeep((Object)this.memoryTracker)), (long)this.memoryTracker.estimatedHeapMemory());
    }
}

