/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.LongSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFileChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.RangeLogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class TransactionLogFiles
extends LifecycleAdapter
implements LogFiles {
    public static final FilenameFilter DEFAULT_FILENAME_FILTER = TransactionLogFilesHelper.DEFAULT_FILENAME_FILTER;
    private final TransactionLogFilesContext logFilesContext;
    private final TransactionLogFileInformation logFileInformation;
    private final LogHeaderCache logHeaderCache;
    private final FileSystemAbstraction fileSystem;
    private final TransactionLogFilesHelper fileHelper;
    private final TransactionLogFile logFile;
    private final File logsDirectory;
    private final TransactionLogChannelAllocator channelAllocator;
    private final LogFileChannelNativeAccessor nativeChannelAccessor;

    TransactionLogFiles(File logsDirectory, String name, TransactionLogFilesContext context) {
        this.logFilesContext = context;
        this.logsDirectory = logsDirectory;
        this.fileHelper = new TransactionLogFilesHelper(context.getFileSystem(), logsDirectory, name);
        this.fileSystem = context.getFileSystem();
        this.logHeaderCache = new LogHeaderCache(1000);
        this.logFileInformation = new TransactionLogFileInformation(this, this.logHeaderCache, context);
        this.nativeChannelAccessor = new LogFileChannelNativeAccessor(this.fileSystem, context);
        this.logFile = new TransactionLogFile(this, context);
        this.channelAllocator = new TransactionLogChannelAllocator(this.logFilesContext, this.fileHelper, this.logHeaderCache, this.nativeChannelAccessor);
    }

    public void init() throws IOException {
        this.logFile.init();
    }

    public void start() throws IOException {
        this.logFile.start();
    }

    public void shutdown() throws IOException {
        this.logFile.shutdown();
    }

    @Override
    public long getLogVersion(File historyLogFile) {
        return this.fileHelper.getLogVersion(historyLogFile);
    }

    @Override
    public File[] logFiles() {
        return this.fileHelper.getLogFiles();
    }

    @Override
    public boolean isLogFile(File file) {
        return this.fileHelper.getLogFilenameFilter().accept(null, file.getName());
    }

    @Override
    public File logFilesDirectory() {
        return this.logsDirectory;
    }

    @Override
    public File getLogFileForVersion(long version) {
        return this.fileHelper.getLogFileForVersion(version);
    }

    @Override
    public File getHighestLogFile() {
        return this.getLogFileForVersion(this.getHighestLogVersion());
    }

    @Override
    public boolean versionExists(long version) {
        return this.fileSystem.fileExists(this.getLogFileForVersion(version));
    }

    @Override
    public LogHeader extractHeader(long version) throws IOException {
        return this.extractHeader(version, true);
    }

    private LogHeader extractHeader(long version, boolean strict) throws IOException {
        LogHeader logHeader = this.logHeaderCache.getLogHeader(version);
        if (logHeader == null) {
            logHeader = LogHeaderReader.readLogHeader(this.fileSystem, this.getLogFileForVersion(version), strict, this.logFilesContext.getMemoryTracker());
            if (!strict && logHeader == null) {
                return null;
            }
            this.logHeaderCache.putHeader(version, logHeader);
        }
        return logHeader;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasAnyEntries(long version) {
        try {
            File logFile = this.getLogFileForVersion(version);
            LogHeader logHeader = this.extractHeader(version, false);
            if (logHeader == null) {
                return false;
            }
            int headerSize = Math.toIntExact(logHeader.getStartPosition().getByteOffset());
            if (this.fileSystem.getFileSize(logFile) <= (long)headerSize) {
                return false;
            }
            try (StoreChannel channel = this.fileSystem.read(logFile);){
                boolean bl;
                try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(headerSize + 1, this.logFilesContext.getMemoryTracker());){
                    ByteBuffer buffer = scopedBuffer.getBuffer();
                    channel.readAll(buffer);
                    buffer.flip();
                    bl = buffer.get(headerSize) != 0;
                }
                return bl;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long getHighestLogVersion() {
        RangeLogVersionVisitor visitor = new RangeLogVersionVisitor();
        this.accept((LogVersionVisitor)visitor);
        return visitor.getHighestVersion();
    }

    @Override
    public long getLowestLogVersion() {
        RangeLogVersionVisitor visitor = new RangeLogVersionVisitor();
        this.accept((LogVersionVisitor)visitor);
        return visitor.getLowestVersion();
    }

    @Override
    public void accept(LogVersionVisitor visitor) {
        for (File file : this.logFiles()) {
            visitor.visit(file, this.getLogVersion(file));
        }
    }

    @Override
    public PhysicalLogVersionedStoreChannel openForVersion(long version) throws IOException {
        return this.channelAllocator.openLogChannel(version);
    }

    @Override
    public PhysicalLogVersionedStoreChannel createLogChannelForVersion(long version, LongSupplier lastTransactionIdSupplier) throws IOException {
        return this.channelAllocator.createLogChannel(version, lastTransactionIdSupplier);
    }

    @Override
    public void accept(LogHeaderVisitor visitor) throws IOException {
        long logVersion = this.getHighestLogVersion();
        long highTransactionId = this.logFilesContext.getLastCommittedTransactionId();
        while (this.versionExists(logVersion)) {
            LogHeader logHeader = this.extractHeader(logVersion, false);
            if (logHeader != null) {
                long lowTransactionId = logHeader.getLastCommittedTxId() + 1L;
                LogPosition position = logHeader.getStartPosition();
                if (!visitor.visit(logHeader, position, lowTransactionId, highTransactionId)) break;
                highTransactionId = logHeader.getLastCommittedTxId();
            }
            --logVersion;
        }
    }

    @Override
    public LogFile getLogFile() {
        return this.logFile;
    }

    @Override
    public TransactionLogFileInformation getLogFileInformation() {
        return this.logFileInformation;
    }

    @Override
    public LogFileChannelNativeAccessor getChannelNativeAccessor() {
        return this.nativeChannelAccessor;
    }
}

