/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.StorageCommandSerializer;
import org.neo4j.storageengine.api.StorageCommand;

public class LogEntryWriter {
    protected final WritableChecksumChannel channel;
    private final Visitor<StorageCommand, IOException> serializer;

    public LogEntryWriter(WritableChecksumChannel channel) {
        this.channel = channel;
        this.serializer = new StorageCommandSerializer((WritableChannel)channel);
    }

    protected static void writeLogEntryHeader(byte type, WritableChannel channel) throws IOException {
        channel.put(LogEntryVersion.LATEST.version()).put(type);
    }

    private void writeStartEntry(LogEntryStart entry) throws IOException {
        this.writeStartEntry(entry.getTimeWritten(), entry.getLastCommittedTxWhenTransactionStarted(), entry.getPreviousChecksum(), entry.getAdditionalHeader());
    }

    public void writeStartEntry(long timeWritten, long latestCommittedTxWhenStarted, int previousChecksum, byte[] additionalHeaderData) throws IOException {
        this.channel.beginChecksum();
        LogEntryWriter.writeLogEntryHeader((byte)1, (WritableChannel)this.channel);
        this.channel.putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(previousChecksum).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
    }

    private int writeCommitEntry(LogEntryCommit entry) throws IOException {
        return this.writeCommitEntry(entry.getTxId(), entry.getTimeWritten());
    }

    public int writeCommitEntry(long transactionId, long timeWritten) throws IOException {
        LogEntryWriter.writeLogEntryHeader((byte)5, (WritableChannel)this.channel);
        this.channel.putLong(transactionId).putLong(timeWritten);
        return this.channel.putChecksum();
    }

    public void serialize(TransactionRepresentation tx) throws IOException {
        tx.accept(this.serializer);
    }

    public void serialize(CommittedTransactionRepresentation tx) throws IOException {
        this.writeStartEntry(tx.getStartEntry());
        this.serialize(tx.getTransactionRepresentation());
        this.writeCommitEntry(tx.getCommitEntry());
    }

    public void serialize(Collection<StorageCommand> commands) throws IOException {
        for (StorageCommand command : commands) {
            this.serializer.visit((Object)command);
        }
    }

    public void writeCheckPointEntry(LogPosition logPosition) throws IOException {
        this.channel.beginChecksum();
        LogEntryWriter.writeLogEntryHeader((byte)7, (WritableChannel)this.channel);
        this.channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset());
        this.channel.putChecksum();
    }
}

