/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.memory.MemoryTracker;

public class ReadAheadLogChannel
extends ReadAheadChannel<LogVersionedStoreChannel>
implements ReadableLogChannel {
    private final LogVersionBridge bridge;

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, MemoryTracker memoryTracker) {
        this(startingChannel, LogVersionBridge.NO_MORE_CHANNELS, (ScopedBuffer)new NativeScopedBuffer(DEFAULT_READ_AHEAD_SIZE, memoryTracker));
    }

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, MemoryTracker memoryTracker) {
        this(startingChannel, bridge, (ScopedBuffer)new NativeScopedBuffer(DEFAULT_READ_AHEAD_SIZE, memoryTracker));
    }

    private ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, ScopedBuffer scopedBuffer) {
        super((StoreChannel)startingChannel, scopedBuffer);
        this.bridge = bridge;
    }

    public long getVersion() {
        return ((LogVersionedStoreChannel)this.channel).getVersion();
    }

    public byte getLogFormatVersion() {
        return ((LogVersionedStoreChannel)this.channel).getLogFormatVersion();
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(((LogVersionedStoreChannel)this.channel).getVersion(), this.position());
        return positionMarker;
    }

    protected LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
        return this.bridge.next(channel);
    }

    public void close() throws IOException {
        super.close();
    }
}

