/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.logging.Log;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.SystemNanoClock;

public class ConfiguringPageCacheFactory {
    private PageSwapperFactory swapperFactory;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final PageCacheTracer pageCacheTracer;
    private final Log log;
    private final VersionContextSupplier versionContextSupplier;
    private PageCache pageCache;
    private final JobScheduler scheduler;
    private final SystemNanoClock clock;
    private final MemoryPools memoryPools;

    public ConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer pageCacheTracer, Log log, VersionContextSupplier versionContextSupplier, JobScheduler scheduler, SystemNanoClock clock, MemoryPools memoryPools) {
        this.fs = fs;
        this.versionContextSupplier = versionContextSupplier;
        this.config = config;
        this.pageCacheTracer = pageCacheTracer;
        this.log = log;
        this.scheduler = scheduler;
        this.clock = clock;
        this.memoryPools = memoryPools;
    }

    public synchronized PageCache getOrCreatePageCache() {
        if (this.pageCache == null) {
            this.swapperFactory = ConfiguringPageCacheFactory.createAndConfigureSwapperFactory(this.fs);
            this.pageCache = this.createPageCache();
        }
        return this.pageCache;
    }

    protected PageCache createPageCache() {
        long pageCacheMaxMemory = this.getPageCacheMaxMemory(this.config);
        GlobalMemoryGroupTracker memoryPool = this.memoryPools.pool(MemoryGroup.PAGE_CACHE, pageCacheMaxMemory, false, null);
        MemoryTracker memoryTracker = memoryPool.getPoolMemoryTracker();
        MemoryAllocator memoryAllocator = this.buildMemoryAllocator(pageCacheMaxMemory, memoryTracker);
        return new MuninnPageCache(this.swapperFactory, memoryAllocator, this.pageCacheTracer, this.versionContextSupplier, this.scheduler, this.clock, memoryTracker);
    }

    private MemoryAllocator buildMemoryAllocator(long pageCacheMaxMemory, MemoryTracker memoryTracker) {
        return MemoryAllocator.createAllocator((long)pageCacheMaxMemory, (MemoryTracker)memoryTracker);
    }

    private long getPageCacheMaxMemory(Config config) {
        Object pageCacheMemorySetting = (String)config.get(GraphDatabaseSettings.pagecache_memory);
        if (pageCacheMemorySetting == null) {
            long heuristic = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory();
            this.log.warn("The " + GraphDatabaseSettings.pagecache_memory.name() + " setting has not been configured. It is recommended that this setting is always explicitly configured, to ensure the system has a balanced configuration. Until then, a computed heuristic value of " + heuristic + " bytes will be used instead. Run `neo4j-admin memrec` for memory configuration suggestions.");
            pageCacheMemorySetting = "" + heuristic;
        }
        return ByteUnit.parse((String)pageCacheMemorySetting);
    }

    public static long defaultHeuristicPageCacheMemory() {
        long maxHeapMemory;
        String defaultMemoryOverride = System.getProperty("dbms.pagecache.memory.default.override");
        if (defaultMemoryOverride != null) {
            return (Long)SettingValueParsers.BYTES.parse(defaultMemoryOverride);
        }
        double ratioOfFreeMem = 0.5;
        String defaultMemoryRatioOverride = System.getProperty("dbms.pagecache.memory.ratio.default.override");
        if (defaultMemoryRatioOverride != null) {
            ratioOfFreeMem = Double.parseDouble(defaultMemoryRatioOverride);
        }
        if (0L < (maxHeapMemory = Runtime.getRuntime().maxMemory()) && maxHeapMemory < Long.MAX_VALUE) {
            try {
                long physicalMemory = OsBeanUtil.getTotalPhysicalMemory();
                if (0L < physicalMemory && physicalMemory < Long.MAX_VALUE && maxHeapMemory < physicalMemory) {
                    long heuristic = (long)((double)(physicalMemory - maxHeapMemory) * ratioOfFreeMem);
                    long min = ByteUnit.mebiBytes((long)32L);
                    long max = Math.min(maxHeapMemory * 70L, ByteUnit.gibiBytes((long)20L));
                    return Math.min(max, Math.max(min, heuristic));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ByteUnit.gibiBytes((long)2L);
    }

    public void dumpConfiguration() {
        String pageCacheMemory = (String)this.config.get(GraphDatabaseSettings.pagecache_memory);
        long totalPhysicalMemory = OsBeanUtil.getTotalPhysicalMemory();
        String totalPhysicalMemMb = totalPhysicalMemory == -1L ? "?" : "" + ByteUnit.Byte.toMebiBytes(totalPhysicalMemory);
        long maxVmUsageMb = ByteUnit.Byte.toMebiBytes(Runtime.getRuntime().maxMemory());
        String msg = "Physical mem: " + totalPhysicalMemMb + " MiB, Heap size: " + maxVmUsageMb + " MiB, Page cache: " + pageCacheMemory + ".";
        this.log.info(msg);
    }

    private static PageSwapperFactory createAndConfigureSwapperFactory(FileSystemAbstraction fs) {
        return new SingleFilePageSwapperFactory(fs);
    }
}

