/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.function.IntSupplier;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdCapacityExceededException;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenCapacityExceededKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;

public class KernelToken
implements Token {
    private final StorageReader store;
    private final CommandCreationContext commandCreationContext;
    private final KernelTransactionImplementation ktx;
    private final TokenHolders tokenHolders;

    public KernelToken(StorageReader store, CommandCreationContext commandCreationContext, KernelTransactionImplementation ktx, TokenHolders tokenHolders) {
        this.store = store;
        this.commandCreationContext = commandCreationContext;
        this.ktx = ktx;
        this.tokenHolders = tokenHolders;
    }

    public int labelGetOrCreateForName(String labelName) throws KernelException {
        return this.getOrCreateForName(this.tokenHolders.labelTokens(), PrivilegeAction.CREATE_LABEL, labelName);
    }

    public void labelGetOrCreateForNames(String[] labelNames, int[] labelIds) throws KernelException {
        this.getOrCreateForNames(this.tokenHolders.labelTokens(), PrivilegeAction.CREATE_LABEL, labelNames, labelIds);
    }

    public int labelCreateForName(String labelName, boolean internal) throws KernelException {
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        int id = KernelToken.reserveTokenId(() -> ((CommandCreationContext)this.commandCreationContext).reserveLabelTokenId(), this.tokenHolders.labelTokens());
        txState.labelDoCreateForName(labelName, internal, id);
        return id;
    }

    public int relationshipTypeCreateForName(String relationshipTypeName, boolean internal) throws KernelException {
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        int id = KernelToken.reserveTokenId(() -> ((CommandCreationContext)this.commandCreationContext).reserveRelationshipTypeTokenId(), this.tokenHolders.relationshipTypeTokens());
        txState.relationshipTypeDoCreateForName(relationshipTypeName, internal, id);
        return id;
    }

    public int propertyKeyCreateForName(String propertyKeyName, boolean internal) throws KernelException {
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        int id = KernelToken.reserveTokenId(() -> ((CommandCreationContext)this.commandCreationContext).reservePropertyKeyTokenId(), this.tokenHolders.propertyKeyTokens());
        txState.propertyKeyDoCreateForName(propertyKeyName, internal, id);
        return id;
    }

    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws KernelException {
        return this.getOrCreateForName(this.tokenHolders.propertyKeyTokens(), PrivilegeAction.CREATE_PROPERTYKEY, propertyKeyName);
    }

    public void propertyKeyGetOrCreateForNames(String[] propertyKeys, int[] ids) throws KernelException {
        this.getOrCreateForNames(this.tokenHolders.propertyKeyTokens(), PrivilegeAction.CREATE_PROPERTYKEY, propertyKeys, ids);
    }

    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws KernelException {
        return this.getOrCreateForName(this.tokenHolders.relationshipTypeTokens(), PrivilegeAction.CREATE_RELTYPE, relationshipTypeName);
    }

    public void relationshipTypeGetOrCreateForNames(String[] relationshipTypes, int[] ids) throws KernelException {
        this.getOrCreateForNames(this.tokenHolders.relationshipTypeTokens(), PrivilegeAction.CREATE_RELTYPE, relationshipTypes, ids);
    }

    public String nodeLabelName(int labelId) throws LabelNotFoundKernelException {
        this.ktx.assertOpen();
        try {
            return this.tokenHolders.labelTokens().getTokenById(labelId).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException((long)labelId, (Exception)((Object)e));
        }
    }

    public int nodeLabel(String name) {
        this.ktx.assertOpen();
        return this.tokenHolders.labelTokens().getIdByName(name);
    }

    public int relationshipType(String name) {
        this.ktx.assertOpen();
        return this.tokenHolders.relationshipTypeTokens().getIdByName(name);
    }

    public String relationshipTypeName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.ktx.assertOpen();
        try {
            return this.tokenHolders.relationshipTypeTokens().getTokenById(relationshipTypeId).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException((long)relationshipTypeId, (Exception)((Object)e));
        }
    }

    public int propertyKey(String name) {
        this.ktx.assertOpen();
        return this.tokenHolders.propertyKeyTokens().getIdByName(name);
    }

    public String propertyKeyName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.ktx.assertOpen();
        try {
            return this.tokenHolders.propertyKeyTokens().getTokenById(propertyKeyId).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, (Exception)((Object)e));
        }
    }

    public Iterator<NamedToken> labelsGetAllTokens() {
        this.ktx.assertOpen();
        AccessMode mode = this.ktx.securityContext().mode();
        return Iterators.stream(this.tokenHolders.labelTokens().getAllTokens().iterator()).filter(label -> mode.allowsTraverseNode(new long[]{label.id()})).iterator();
    }

    public Iterator<NamedToken> propertyKeyGetAllTokens() {
        this.ktx.assertOpen();
        AccessMode mode = this.ktx.securityContext().mode();
        return Iterators.stream(this.tokenHolders.propertyKeyTokens().getAllTokens().iterator()).filter(propKey -> mode.allowsSeePropertyKeyToken(propKey.id())).iterator();
    }

    public Iterator<NamedToken> relationshipTypesGetAllTokens() {
        this.ktx.assertOpen();
        AccessMode mode = this.ktx.securityContext().mode();
        return Iterators.stream(this.tokenHolders.relationshipTypeTokens().getAllTokens().iterator()).filter(relType -> mode.allowsTraverseRelType(relType.id())).iterator();
    }

    public int labelCount() {
        this.ktx.assertOpen();
        return this.store.labelCount();
    }

    public int propertyKeyCount() {
        this.ktx.assertOpen();
        return this.store.propertyKeyCount();
    }

    public int relationshipTypeCount() {
        this.ktx.assertOpen();
        return this.store.relationshipTypeCount();
    }

    private static String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty() || name.contains("\u0000") || name.contains("`")) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }

    private int getOrCreateForName(TokenHolder tokens, PrivilegeAction action, String name) throws KernelException {
        this.ktx.assertOpen();
        int id = tokens.getIdByName(KernelToken.checkValidTokenName(name));
        if (id != -1) {
            return id;
        }
        this.ktx.assertAllowsTokenCreates(action);
        return tokens.getOrCreateId(name);
    }

    private void getOrCreateForNames(TokenHolder tokenHolder, PrivilegeAction action, String[] names, int[] ids) throws KernelException {
        this.ktx.assertOpen();
        KernelToken.assertSameLength(names, ids);
        for (int i = 0; i < names.length; ++i) {
            ids[i] = tokenHolder.getIdByName(KernelToken.checkValidTokenName(names[i]));
            if (ids[i] != -1) continue;
            this.ktx.assertAllowsTokenCreates(action);
            tokenHolder.getOrCreateIds(names, ids);
            return;
        }
    }

    private static void assertSameLength(String[] names, int[] ids) {
        if (names.length != ids.length) {
            throw new IllegalArgumentException("Name and id arrays have different length.");
        }
    }

    private static int reserveTokenId(IntSupplier generator, TokenHolder holder) throws KernelException {
        try {
            int id;
            while (holder.hasToken(id = generator.getAsInt())) {
            }
            return id;
        }
        catch (IdCapacityExceededException e) {
            throw new TokenCapacityExceededKernelException((Throwable)e, holder.getTokenType());
        }
    }

    public String labelGetName(int labelId) {
        this.ktx.assertOpen();
        return this.tokenHolders.labelGetName(labelId);
    }

    public String relationshipTypeGetName(int relationshipTypeId) {
        this.ktx.assertOpen();
        return this.tokenHolders.relationshipTypeGetName(relationshipTypeId);
    }

    public String propertyKeyGetName(int propertyKeyId) {
        this.ktx.assertOpen();
        return this.tokenHolders.propertyKeyGetName(propertyKeyId);
    }
}

