/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.procedure.BasicContext;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.IndexReaderCache;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.newapi.DefaultIndexReadSession;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.SchemaReadCoreSnapshot;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.Value;

public class AllStoreHolder
extends Read {
    private final GlobalProcedures globalProcedures;
    private final SchemaState schemaState;
    private final IndexingService indexingService;
    private final LabelScanStore labelScanStore;
    private final RelationshipTypeScanStore relationshipTypeScanStore;
    private final IndexStatisticsStore indexStatisticsStore;
    private final Dependencies databaseDependencies;
    private final MemoryTracker memoryTracker;
    private final IndexReaderCache indexReaderCache;
    private TokenScanReader labelScanReader;
    private TokenScanReader relationshipTypeScanReader;

    public AllStoreHolder(StorageReader storageReader, KernelTransactionImplementation ktx, DefaultPooledCursors cursors, GlobalProcedures globalProcedures, SchemaState schemaState, IndexingService indexingService, LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, IndexStatisticsStore indexStatisticsStore, PageCursorTracer cursorTracer, Dependencies databaseDependencies, Config config, MemoryTracker memoryTracker) {
        super(storageReader, cursors, cursorTracer, ktx, config);
        this.globalProcedures = globalProcedures;
        this.schemaState = schemaState;
        this.indexReaderCache = new IndexReaderCache(indexingService);
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.relationshipTypeScanStore = relationshipTypeScanStore;
        this.indexStatisticsStore = indexStatisticsStore;
        this.databaseDependencies = databaseDependencies;
        this.memoryTracker = memoryTracker;
    }

    public boolean nodeExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.nodeIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(reference)) {
                return true;
            }
        }
        AccessMode mode = this.ktx.securityContext().mode();
        boolean existsInNodeStore = this.storageReader.nodeExists(reference, this.cursorTracer);
        if (mode.allowsTraverseAllLabels()) {
            return existsInNodeStore;
        }
        if (!existsInNodeStore) {
            return false;
        }
        try (DefaultNodeCursor node = this.cursors.allocateNodeCursor(this.cursorTracer);){
            this.ktx.dataRead().singleNode(reference, (NodeCursor)node);
            boolean bl = node.next();
            return bl;
        }
    }

    public boolean nodeDeletedInTransaction(long node) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() && this.txState().nodeIsDeletedInThisTx(node);
    }

    public boolean relationshipDeletedInTransaction(long relationship) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() && this.txState().relationshipIsDeletedInThisTx(relationship);
    }

    public Value nodePropertyChangeInTransactionOrNull(long node, int propertyKeyId) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() ? this.txState().getNodeState(node).propertyValue(propertyKeyId) : null;
    }

    public Value relationshipPropertyChangeInTransactionOrNull(long relationship, int propertyKeyId) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() ? this.txState().getRelationshipState(relationship).propertyValue(propertyKeyId) : null;
    }

    public long countsForNode(int labelId) {
        return this.countsForNodeWithoutTxState(labelId) + this.countsForNodeInTxState(labelId);
    }

    public long countsForNodeWithoutTxState(int labelId) {
        long result;
        AccessMode mode = this.ktx.securityContext().mode();
        if (mode.allowsTraverseAllLabels()) {
            return this.storageReader.countsForNode(labelId, this.cursorTracer);
        }
        long count = 0L;
        try (DefaultNodeCursor nodes = this.cursors.allocateNodeCursor(this.cursorTracer);){
            this.allNodesScan(nodes);
            while (nodes.next()) {
                if (labelId != -1 && !nodes.hasLabel(labelId)) continue;
                ++count;
            }
            result = count;
        }
        return result - this.countsForNodeInTxState(labelId);
    }

    private long countsForNodeInTxState(int labelId) {
        long count = 0L;
        if (this.ktx.hasTxStateWithChanges()) {
            CountsDelta counts = new CountsDelta();
            try {
                TransactionState txState = this.ktx.txState();
                try (TransactionCountingStateVisitor countingVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, (ReadableTransactionState)txState, counts, this.cursorTracer);){
                    txState.accept((TxStateVisitor)countingVisitor);
                }
                if (counts.hasChanges()) {
                    count += counts.nodeCount(labelId, this.cursorTracer);
                }
            }
            catch (KernelException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        return this.countsForRelationshipWithoutTxState(startLabelId, typeId, endLabelId) + this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
    }

    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        long count;
        AccessMode mode = this.ktx.securityContext().mode();
        if (mode.allowsTraverseRelType(typeId) && mode.allowsTraverseNode(new long[]{startLabelId}) && mode.allowsTraverseNode(new long[]{endLabelId})) {
            return this.storageReader.countsForRelationship(startLabelId, typeId, endLabelId, this.cursorTracer);
        }
        if (this.relationshipTypeScanStoreEnabled()) {
            long count2 = 0L;
            try (DefaultRelationshipTypeIndexCursor relationshipsWithType = this.cursors.allocateRelationshipTypeIndexCursor();
                 DefaultRelationshipScanCursor relationship = this.cursors.allocateRelationshipScanCursor(this.cursorTracer);
                 DefaultNodeCursor sourceNode = this.cursors.allocateNodeCursor(this.cursorTracer);
                 DefaultNodeCursor targetNode = this.cursors.allocateNodeCursor(this.cursorTracer);){
                this.relationshipTypeScan(typeId, relationshipsWithType);
                while (relationshipsWithType.next()) {
                    relationshipsWithType.relationship(relationship);
                    count2 += AllStoreHolder.countRelationshipsWithEndLabels(relationship, sourceNode, targetNode, startLabelId, endLabelId);
                }
            }
            return count2 - this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
        }
        try (DefaultRelationshipScanCursor rels = this.cursors.allocateRelationshipScanCursor(this.cursorTracer);
             FullAccessNodeCursor sourceNode = this.cursors.allocateFullAccessNodeCursor(this.cursorTracer);
             FullAccessNodeCursor targetNode = this.cursors.allocateFullAccessNodeCursor(this.cursorTracer);){
            this.relationshipTypeScan(typeId, rels);
            count = AllStoreHolder.countRelationshipsWithEndLabels(rels, sourceNode, targetNode, startLabelId, endLabelId);
        }
        return count - this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
    }

    private static long countRelationshipsWithEndLabels(DefaultRelationshipScanCursor relationship, DefaultNodeCursor sourceNode, DefaultNodeCursor targetNode, int startLabelId, int endLabelId) {
        long internalCount = 0L;
        while (relationship.next()) {
            relationship.source(sourceNode);
            relationship.target(targetNode);
            if (!sourceNode.next() || startLabelId != -1 && !sourceNode.hasLabel(startLabelId) || !targetNode.next() || endLabelId != -1 && !targetNode.hasLabel(endLabelId)) continue;
            ++internalCount;
        }
        return internalCount;
    }

    private long countsForRelationshipInTxState(int startLabelId, int typeId, int endLabelId) {
        long count = 0L;
        if (this.ktx.hasTxStateWithChanges()) {
            CountsDelta counts = new CountsDelta();
            try {
                TransactionState txState = this.ktx.txState();
                try (TransactionCountingStateVisitor countingVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, (ReadableTransactionState)txState, counts, this.cursorTracer);){
                    txState.accept((TxStateVisitor)countingVisitor);
                }
                if (counts.hasChanges()) {
                    count += counts.relationshipCount(startLabelId, typeId, endLabelId, this.cursorTracer);
                }
            }
            catch (KernelException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public boolean relationshipExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.relationshipIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.relationshipIsAddedInThisTx(reference)) {
                return true;
            }
        }
        AccessMode mode = this.ktx.securityContext().mode();
        boolean existsInRelStore = this.storageReader.relationshipExists(reference, this.cursorTracer);
        if (mode.allowsTraverseAllRelTypes()) {
            return existsInRelStore;
        }
        if (!existsInRelStore) {
            return false;
        }
        try (DefaultRelationshipScanCursor rels = this.cursors.allocateRelationshipScanCursor(this.cursorTracer);){
            this.ktx.dataRead().singleRelationship(reference, (RelationshipScanCursor)rels);
            boolean bl = rels.next();
            return bl;
        }
    }

    @Override
    public IndexReader indexReader(IndexDescriptor index, boolean fresh) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return fresh ? this.indexReaderCache.newUnCachedReader(index) : this.indexReaderCache.getOrCreate(index);
    }

    public IndexReadSession indexReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return new DefaultIndexReadSession(this.indexReaderCache.getOrCreate(index), index);
    }

    public void prepareForLabelScans() {
        this.labelScanReader();
    }

    @Override
    TokenScanReader labelScanReader() {
        if (this.labelScanReader == null) {
            this.labelScanReader = this.labelScanStore.newReader();
        }
        return this.labelScanReader;
    }

    @Override
    TokenScanReader relationshipTypeScanReader() {
        if (this.relationshipTypeScanReader == null) {
            this.relationshipTypeScanReader = this.relationshipTypeScanStore.newReader();
        }
        return this.relationshipTypeScanReader;
    }

    public Iterator<IndexDescriptor> indexForSchemaNonTransactional(SchemaDescriptor schema) {
        return this.storageReader.indexGetForSchema(schema);
    }

    private IndexDescriptor lockIndex(IndexDescriptor index) {
        if (index == null) {
            return IndexDescriptor.NO_INDEX;
        }
        if (!this.indexExists(index = this.acquireSharedSchemaLock(index))) {
            this.releaseSharedSchemaLock(index);
            index = IndexDescriptor.NO_INDEX;
        }
        return index;
    }

    private Iterator<IndexDescriptor> lockIndexes(Iterator<IndexDescriptor> indexes) {
        Predicate<IndexDescriptor> exists = index -> index != IndexDescriptor.NO_INDEX;
        return Iterators.filter(exists, (Iterator)Iterators.map(this::lockIndex, indexes));
    }

    private boolean indexExists(IndexDescriptor index) {
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets changes = this.ktx.txState().indexChanges();
            return changes.isAdded((Object)index) || this.storageReader.indexExists(index) && !changes.isRemoved((Object)index);
        }
        return this.storageReader.indexExists(index);
    }

    public void assertIndexExists(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (!this.indexExists(index)) {
            throw new IndexNotFoundKernelException("Index does not exist: ", index);
        }
    }

    private ConstraintDescriptor lockConstraint(ConstraintDescriptor constraint) {
        if (constraint == null) {
            return null;
        }
        if (!this.constraintExists(constraint = this.acquireSharedSchemaLock(constraint))) {
            this.releaseSharedSchemaLock(constraint);
            constraint = null;
        }
        return constraint;
    }

    private Iterator<ConstraintDescriptor> lockConstraints(Iterator<ConstraintDescriptor> constraints) {
        return Iterators.filter(Objects::nonNull, (Iterator)Iterators.map(this::lockConstraint, constraints));
    }

    public boolean constraintExists(ConstraintDescriptor constraint) {
        this.acquireSharedSchemaLock(constraint);
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets changes = this.ktx.txState().constraintsChanges();
            return changes.isAdded((Object)constraint) || this.storageReader.constraintExists(constraint) && !changes.isRemoved((Object)constraint);
        }
        return this.storageReader.constraintExists(constraint);
    }

    public Iterator<IndexDescriptor> index(SchemaDescriptor schema) {
        this.ktx.assertOpen();
        return this.lockIndexes(this.indexGetForSchema((StorageSchemaReader)this.storageReader, schema));
    }

    Iterator<IndexDescriptor> indexGetForSchema(StorageSchemaReader reader, SchemaDescriptor schema) {
        Iterator indexes = reader.indexGetForSchema(schema);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets diffSets = this.ktx.txState().indexDiffSetsBySchema(schema);
            indexes = diffSets.apply(indexes);
        }
        return indexes;
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.acquireSharedLock((ResourceType)ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        return this.lockIndexes(this.indexesGetForLabel((StorageSchemaReader)this.storageReader, labelId));
    }

    Iterator<IndexDescriptor> indexesGetForLabel(StorageSchemaReader reader, int labelId) {
        if (this.ktx.securityContext().mode().allowsTraverseNode(new long[]{labelId})) {
            Iterator iterator = reader.indexesGetForLabel(labelId);
            if (this.ktx.hasTxStateWithChanges()) {
                iterator = this.ktx.txState().indexDiffSetsByLabel(labelId).apply(iterator);
            }
            return iterator;
        }
        return Collections.emptyIterator();
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        this.acquireSharedLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, relationshipType);
        this.ktx.assertOpen();
        return this.lockIndexes(this.indexesGetForRelationshipType((StorageSchemaReader)this.storageReader, relationshipType));
    }

    Iterator<IndexDescriptor> indexesGetForRelationshipType(StorageSchemaReader reader, int relationshipType) {
        Iterator iterator = reader.indexesGetForRelationshipType(relationshipType);
        if (this.ktx.hasTxStateWithChanges()) {
            iterator = this.ktx.txState().indexDiffSetsByRelationshipType(relationshipType).apply(iterator);
        }
        return iterator;
    }

    public IndexDescriptor indexGetForName(String name) {
        return this.indexGetForName((StorageSchemaReader)this.storageReader, name);
    }

    IndexDescriptor indexGetForName(StorageSchemaReader reader, String name) {
        this.ktx.assertOpen();
        IndexDescriptor index = reader.indexGetForName(name);
        if (this.ktx.hasTxStateWithChanges()) {
            Predicate<IndexDescriptor> namePredicate = indexDescriptor -> indexDescriptor.getName().equals(name);
            Iterator indexes = this.ktx.txState().indexChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)index));
            index = (IndexDescriptor)Iterators.singleOrNull((Iterator)indexes);
        }
        return this.lockIndex(index);
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return this.constraintGetForName((StorageSchemaReader)this.storageReader, name);
    }

    ConstraintDescriptor constraintGetForName(StorageSchemaReader reader, String name) {
        this.ktx.assertOpen();
        ConstraintDescriptor constraint = reader.constraintGetForName(name);
        if (this.ktx.hasTxStateWithChanges()) {
            Predicate<ConstraintDescriptor> namePredicate = constraintDescriptor -> constraintDescriptor.getName().equals(name);
            Iterator constraints = this.ktx.txState().constraintsChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)constraint));
            constraint = (ConstraintDescriptor)Iterators.singleOrNull((Iterator)constraints);
        }
        return this.lockConstraint(constraint);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        this.ktx.assertOpen();
        Iterator<IndexDescriptor> iterator = this.indexesGetAll((StorageSchemaReader)this.storageReader);
        return this.lockIndexes(iterator);
    }

    Iterator<IndexDescriptor> indexesGetAll(StorageSchemaReader reader) {
        Iterator iterator = reader.indexesGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            iterator = this.ktx.txState().indexChanges().apply(iterator);
        }
        return iterator;
    }

    public InternalIndexState indexGetState(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        return this.indexGetStateLocked(index);
    }

    InternalIndexState indexGetStateLocked(IndexDescriptor index) throws IndexNotFoundKernelException {
        SchemaDescriptor schema = index.schema();
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState(index, (DiffSets<IndexDescriptor>)this.ktx.txState().indexDiffSetsBySchema(schema))) {
            return InternalIndexState.POPULATING;
        }
        return this.indexingService.getIndexProxy(index).getState();
    }

    public PopulationProgress indexGetPopulationProgress(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        return this.indexGetPopulationProgressLocked(index);
    }

    PopulationProgress indexGetPopulationProgressLocked(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState(index, (DiffSets<IndexDescriptor>)this.ktx.txState().indexDiffSetsBySchema(index.schema()))) {
            return PopulationProgress.NONE;
        }
        return this.indexingService.getIndexProxy(index).getIndexPopulationProgress();
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        return this.storageReader.indexGetOwningUniquenessConstraintId(this.storageReader.indexGetForName(index.getName()));
    }

    public String indexGetFailure(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).getPopulationFailure().asString();
    }

    public double indexUniqueValuesSelectivity(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        this.assertIndexExists(index);
        IndexSample indexSample = this.indexStatisticsStore.indexSample(index.getId());
        long unique = indexSample.uniqueValues();
        long size = indexSample.sampleSize();
        return size == 0L ? 1.0 : (double)unique / (double)size;
    }

    public long indexSize(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        return this.indexStatisticsStore.indexSample(index.getId()).indexSize();
    }

    public long nodesCountIndexed(IndexDescriptor index, long nodeId, int propertyKeyId, Value value) throws KernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        IndexReader reader = this.indexReaderCache.getOrCreate(index);
        return reader.countIndexedNodes(nodeId, this.cursorTracer, new int[]{propertyKeyId}, new Value[]{value});
    }

    public long nodesGetCount() {
        return this.countsForNode(-1);
    }

    public long relationshipsGetCount() {
        return this.countsForRelationship(-1, -1, -1);
    }

    public IndexSample indexSample(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        return this.indexStatisticsStore.indexSample(index.getId());
    }

    private boolean checkIndexState(IndexDescriptor index, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded((Object)index)) {
            return true;
        }
        if (diffSet.isRemoved((Object)index)) {
            throw new IndexNotFoundKernelException("Index has been dropped in this transaction: ", index);
        }
        return false;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor schema) {
        this.acquireSharedSchemaLock(schema);
        this.ktx.assertOpen();
        Iterator constraints = this.storageReader.constraintsGetForSchema(schema);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForSchema(schema).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.acquireSharedLock((ResourceType)ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        return this.constraintsGetForLabel((StorageSchemaReader)this.storageReader, labelId);
    }

    Iterator<ConstraintDescriptor> constraintsGetForLabel(StorageSchemaReader reader, int labelId) {
        Iterator constraints = reader.constraintsGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.constraintsGetAll((StorageSchemaReader)this.storageReader);
        return this.lockConstraints(constraints);
    }

    Iterator<ConstraintDescriptor> constraintsGetAll(StorageSchemaReader reader) {
        Iterator constraints = reader.constraintsGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            constraints = this.ktx.txState().constraintsChanges().apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.acquireSharedLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, typeId);
        this.ktx.assertOpen();
        return this.constraintsGetForRelationshipType((StorageSchemaReader)this.storageReader, typeId);
    }

    Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(StorageSchemaReader reader, int typeId) {
        Iterator constraints = reader.constraintsGetForRelationshipType(typeId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    public SchemaReadCore snapshot() {
        this.ktx.assertOpen();
        StorageSchemaReader snapshot = this.storageReader.schemaSnapshot();
        return new SchemaReadCoreSnapshot(snapshot, this.ktx, this);
    }

    public UserFunctionHandle functionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.globalProcedures.function(name);
    }

    public ProcedureHandle procedureGet(QualifiedName name) throws ProcedureException {
        this.ktx.assertOpen();
        return this.globalProcedures.procedure(name);
    }

    public Set<ProcedureSignature> proceduresGetAll() {
        this.ktx.assertOpen();
        return this.globalProcedures.getAllProcedures();
    }

    public UserFunctionHandle aggregationFunctionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.globalProcedures.aggregationFunction(name);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallRead(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.callProcedure(id, arguments, new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ), context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallReadOverride(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.callProcedure(id, arguments, new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ), context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallWrite(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.callProcedure(id, arguments, new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE), context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallWriteOverride(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.callProcedure(id, arguments, new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE), context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallSchema(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id, arguments, new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL), context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallSchemaOverride(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.callProcedure(id, arguments, new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL), context);
    }

    public AnyValue functionCall(int id, AnyValue[] arguments) throws ProcedureException {
        return this.callFunction(id, arguments, new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public AnyValue functionCallOverride(int id, AnyValue[] arguments) throws ProcedureException {
        return this.callFunction(id, arguments, new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunction(int id) throws ProcedureException {
        return this.aggregationFunction(id, new RestrictedAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public UserAggregator aggregationFunctionOverride(int id) throws ProcedureException {
        return this.aggregationFunction(id, new OverriddenAccessMode(this.ktx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return (V)this.schemaState.getOrCreate(key, creator);
    }

    public void schemaStateFlush() {
        this.schemaState.clear();
    }

    public boolean transactionStateHasChanges() {
        return this.txState().hasChanges();
    }

    private RawIterator<AnyValue[], ProcedureException> callProcedure(int id, AnyValue[] input, AccessMode override, ProcedureCallContext procedureCallContext) throws ProcedureException {
        RawIterator<AnyValue[], ProcedureException> procedureCall;
        this.ktx.assertOpen();
        SecurityContext procedureSecurityContext = this.ktx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
             KernelStatement statement = this.ktx.acquireStatement();){
            procedureCall = this.globalProcedures.callProcedure(this.prepareContext(procedureSecurityContext, procedureCallContext), id, input, statement);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    private RawIterator<AnyValue[], ProcedureException> createIterator(final SecurityContext procedureSecurityContext, final RawIterator<AnyValue[], ProcedureException> procedureCall) {
        return new RawIterator<AnyValue[], ProcedureException>(){

            public boolean hasNext() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = AllStoreHolder.this.ktx.overrideWith(procedureSecurityContext);){
                    boolean bl = procedureCall.hasNext();
                    return bl;
                }
            }

            public AnyValue[] next() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = AllStoreHolder.this.ktx.overrideWith(procedureSecurityContext);){
                    AnyValue[] anyValueArray = (AnyValue[])procedureCall.next();
                    return anyValueArray;
                }
            }
        };
    }

    private AnyValue callFunction(int id, AnyValue[] input, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            AnyValue anyValue = this.globalProcedures.callFunction(this.prepareContext(securityContext, ProcedureCallContext.EMPTY), id, input);
            return anyValue;
        }
    }

    private UserAggregator aggregationFunction(int id, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            UserAggregator userAggregator = this.globalProcedures.createAggregationFunction(this.prepareContext(securityContext, ProcedureCallContext.EMPTY), id);
            return userAggregator;
        }
    }

    private Context prepareContext(SecurityContext securityContext, ProcedureCallContext procedureContext) {
        InternalTransaction internalTransaction = this.ktx.internalTransaction();
        return BasicContext.buildContext((DependencyResolver)this.databaseDependencies, (ValueMapper<Object>)new DefaultValueMapper(internalTransaction)).withTransaction(internalTransaction).withSecurityContext(securityContext).withProcedureCallContext(procedureContext).context();
    }

    static void assertValidIndex(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (index == IndexDescriptor.NO_INDEX) {
            throw new IndexNotFoundKernelException("No index was found");
        }
    }

    public void release() {
        this.indexReaderCache.close();
    }

    public PageCursorTracer cursorTracer() {
        return this.cursorTracer;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }
}

