/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenCapacityExceededKernelException;
import org.neo4j.internal.kernel.api.helpers.Nodes;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.values.storable.Values;

public class NodeEntity
implements Node,
RelationshipFactory<Relationship> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeEntity.class);
    private final InternalTransaction internalTransaction;
    private final long nodeId;

    public NodeEntity(InternalTransaction internalTransaction, long nodeId) {
        this.internalTransaction = internalTransaction;
        this.nodeId = nodeId;
    }

    public static boolean isDeletedInCurrentTransaction(Node node) {
        if (node instanceof NodeEntity) {
            NodeEntity proxy = (NodeEntity)node;
            KernelTransaction ktx = proxy.internalTransaction.kernelTransaction();
            return ktx.dataRead().nodeDeletedInTransaction(proxy.nodeId);
        }
        return false;
    }

    public long getId() {
        return this.nodeId;
    }

    public void delete() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            boolean deleted = transaction.dataWrite().nodeDelete(this.getId());
            if (!deleted) {
                throw new NotFoundException("Unable to delete Node[" + this.nodeId + "] since it has already been deleted.");
            }
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public ResourceIterable<Relationship> getRelationships() {
        return this.getRelationships(Direction.BOTH);
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        return this.innerGetRelationships(transaction, direction, null);
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.getRelationships(Direction.BOTH, types);
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int[] typeIds = this.relTypeIds(types, transaction.tokenRead());
        return this.innerGetRelationships(transaction, direction, typeIds);
    }

    private ResourceIterable<Relationship> innerGetRelationships(KernelTransaction transaction, Direction direction, int[] typeIds) {
        return () -> this.getRelationshipSelectionIterator(transaction, direction, typeIds);
    }

    public boolean hasRelationship() {
        return this.hasRelationship(Direction.BOTH);
    }

    public boolean hasRelationship(Direction direction) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        return this.innerHasRelationships(transaction, direction, null);
    }

    public boolean hasRelationship(RelationshipType ... types) {
        return this.hasRelationship(Direction.BOTH, types);
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int[] typeIds = this.relTypeIds(types, transaction.tokenRead());
        return this.innerHasRelationships(transaction, direction, typeIds);
    }

    private boolean innerHasRelationships(KernelTransaction transaction, Direction direction, int[] typeIds) {
        try (ResourceIterator<Relationship> iterator = this.getRelationshipSelectionIterator(transaction, direction, typeIds);){
            boolean bl = iterator.hasNext();
            return bl;
        }
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        try (ResourceIterator rels = this.getRelationships(dir, type).iterator();){
            if (!rels.hasNext()) {
                Relationship relationship = null;
                return relationship;
            }
            Relationship rel = (Relationship)rels.next();
            while (rels.hasNext()) {
                Relationship other = (Relationship)rels.next();
                if (other.equals(rel)) continue;
                throw new NotFoundException("More than one relationship[" + type + ", " + dir + "] found for " + this);
            }
            Relationship relationship = rel;
            return relationship;
        }
    }

    public void setProperty(String key, Object value) {
        int propertyKeyId;
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (TokenCapacityExceededKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (KernelException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Unknown error trying to create property key token", (Throwable)e);
        }
        try {
            transaction.dataWrite().nodeSetProperty(this.nodeId, propertyKeyId, Values.of((Object)value, (boolean)false));
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)transaction.tokenRead()), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            try {
                transaction.rollback();
            }
            catch (TransactionFailureException ex) {
                ex.addSuppressed((Throwable)e);
                throw new org.neo4j.graphdb.TransactionFailureException("Fail to rollback transaction.", (Throwable)ex);
            }
            throw e;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Object removeProperty(String key) throws NotFoundException {
        int propertyKeyId;
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (KernelException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Unknown error trying to get property key token", (Throwable)e);
        }
        try {
            return transaction.dataWrite().nodeRemoveProperty(this.nodeId, propertyKeyId).asObjectCopy();
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return defaultValue;
        }
        this.singleNode(transaction, nodes);
        nodes.properties(properties);
        return properties.seekProperty(propertyKey) ? properties.propertyValue().asObjectCopy() : defaultValue;
    }

    public Iterable<String> getPropertyKeys() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            NodeCursor nodes = transaction.ambientNodeCursor();
            PropertyCursor properties = transaction.ambientPropertyCursor();
            this.singleNode(transaction, nodes);
            TokenRead token = transaction.tokenRead();
            nodes.properties(properties);
            while (properties.next()) {
                keys.add(token.propertyKeyName(properties.propertyKey()));
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return keys;
    }

    public Map<String, Object> getProperties(String ... keys) {
        Objects.requireNonNull(keys, "Properties keys should be not null array.");
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int itemsToReturn = keys.length;
        HashMap<String, Object> properties = new HashMap<String, Object>(itemsToReturn);
        TokenRead token = transaction.tokenRead();
        int[] propertyIds = new int[itemsToReturn];
        for (int i = 0; i < itemsToReturn; ++i) {
            String key = keys[i];
            if (key == null) {
                throw new NullPointerException(String.format("Key %d was null", i));
            }
            propertyIds[i] = token.propertyKey(key);
        }
        NodeCursor nodes = transaction.ambientNodeCursor();
        PropertyCursor propertyCursor = transaction.ambientPropertyCursor();
        this.singleNode(transaction, nodes);
        nodes.properties(propertyCursor);
        int propertiesToFind = itemsToReturn;
        block1: while (propertiesToFind > 0 && propertyCursor.next()) {
            int currentKey = propertyCursor.propertyKey();
            for (int i = 0; i < itemsToReturn; ++i) {
                if (propertyIds[i] != currentKey) continue;
                properties.put(keys[i], propertyCursor.propertyValue().asObjectCopy());
                --propertiesToFind;
                continue block1;
            }
        }
        return properties;
    }

    public Map<String, Object> getAllProperties() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            NodeCursor nodes = transaction.ambientNodeCursor();
            PropertyCursor propertyCursor = transaction.ambientPropertyCursor();
            TokenRead token = transaction.tokenRead();
            this.singleNode(transaction, nodes);
            nodes.properties(propertyCursor);
            while (propertyCursor.next()) {
                properties.put(token.propertyKeyName(propertyCursor.propertyKey()), propertyCursor.propertyValue().asObjectCopy());
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return properties;
    }

    public Object getProperty(String key) throws NotFoundException {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        NodeCursor nodes = transaction.ambientNodeCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        this.singleNode(transaction, nodes);
        nodes.properties(properties);
        if (!properties.seekProperty(propertyKey)) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        return properties.propertyValue().asObjectCopy();
    }

    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return false;
        }
        NodeCursor nodes = transaction.ambientNodeCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        this.singleNode(transaction, nodes);
        nodes.properties(properties);
        return properties.seekProperty(propertyKey);
    }

    public int compareTo(Object node) {
        Node n = (Node)node;
        return Long.compare(this.getId(), n.getId());
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        int relationshipTypeId;
        if (otherNode == null) {
            throw new IllegalArgumentException("Other node is null.");
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            relationshipTypeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName(type.name());
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (TokenCapacityExceededKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (KernelException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Unknown error trying to create relationship type token", (Throwable)e);
        }
        try {
            long relationshipId = transaction.dataWrite().relationshipCreate(this.nodeId, relationshipTypeId, otherNode.getId());
            return this.internalTransaction.newRelationshipEntity(relationshipId, this.nodeId, relationshipTypeId, otherNode.getId());
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node[" + e.entityId() + "] is deleted and cannot be used to create a relationship");
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public void addLabel(Label label) {
        int labelId;
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            labelId = transaction.tokenWrite().labelGetOrCreateForName(label.name());
        }
        catch (IllegalTokenNameException e) {
            throw new ConstraintViolationException(String.format("Invalid label name '%s'.", label.name()), (Throwable)e);
        }
        catch (TokenCapacityExceededKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (KernelException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Unknown error trying to create label token", (Throwable)e);
        }
        try {
            transaction.dataWrite().nodeAddLabel(this.getId(), labelId);
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)transaction.tokenRead()), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", (Throwable)e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeLabel(Label label) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            int labelId = transaction.tokenRead().nodeLabel(label.name());
            if (labelId != -1) {
                transaction.dataWrite().nodeRemoveLabel(this.getId(), labelId);
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", (Throwable)e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasLabel(Label label) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        int labelId = transaction.tokenRead().nodeLabel(label.name());
        if (labelId == -1) {
            return false;
        }
        transaction.dataRead().singleNode(this.nodeId, nodes);
        return nodes.next() && nodes.hasLabel(labelId);
    }

    public Iterable<Label> getLabels() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        try {
            this.singleNode(transaction, nodes);
            TokenSet tokenSet = nodes.labels();
            TokenRead tokenRead = transaction.tokenRead();
            ArrayList<Label> list = new ArrayList<Label>(tokenSet.numberOfTokens());
            for (int i = 0; i < tokenSet.numberOfTokens(); ++i) {
                list.add(Label.label((String)tokenRead.nodeLabelName(tokenSet.token(i))));
            }
            return list;
        }
        catch (LabelNotFoundKernelException e) {
            throw new IllegalStateException("Label retrieved through kernel API should exist.", e);
        }
    }

    public int getDegree() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(transaction, nodes);
        return Nodes.countAll((NodeCursor)nodes);
    }

    public int getDegree(RelationshipType type) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int typeId = transaction.tokenRead().relationshipType(type.name());
        if (typeId == -1) {
            return 0;
        }
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(transaction, nodes);
        return Nodes.countAll((NodeCursor)nodes, (int)typeId);
    }

    public int getDegree(Direction direction) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(transaction, nodes);
        switch (direction) {
            case OUTGOING: {
                return Nodes.countOutgoing((NodeCursor)nodes);
            }
            case INCOMING: {
                return Nodes.countIncoming((NodeCursor)nodes);
            }
            case BOTH: {
                return Nodes.countAll((NodeCursor)nodes);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    public int getDegree(RelationshipType type, Direction direction) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int typeId = transaction.tokenRead().relationshipType(type.name());
        if (typeId == -1) {
            return 0;
        }
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(transaction, nodes);
        switch (direction) {
            case OUTGOING: {
                return Nodes.countOutgoing((NodeCursor)nodes, (int)typeId);
            }
            case INCOMING: {
                return Nodes.countIncoming((NodeCursor)nodes, (int)typeId);
            }
            case BOTH: {
                return Nodes.countAll((NodeCursor)nodes, (int)typeId);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            NodeCursor nodes = transaction.ambientNodeCursor();
            TokenRead tokenRead = transaction.tokenRead();
            this.singleNode(transaction, nodes);
            Degrees degrees = nodes.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
            ArrayList<RelationshipType> types = new ArrayList<RelationshipType>();
            for (int type : degrees.types()) {
                if (degrees.totalDegree(type) <= 0) continue;
                types.add(RelationshipType.withName((String)tokenRead.relationshipTypeName(type)));
            }
            return types;
        }
        catch (KernelException e) {
            throw new NotFoundException("Relationship name not found.", (Throwable)e);
        }
    }

    private ResourceIterator<Relationship> getRelationshipSelectionIterator(KernelTransaction transaction, Direction direction, int[] typeIds) {
        NodeCursor node = transaction.ambientNodeCursor();
        transaction.dataRead().singleNode(this.getId(), node);
        if (!node.next()) {
            throw new NotFoundException(String.format("Node %d not found", this.nodeId));
        }
        PageCursorTracer cursorTracer = transaction.pageCursorTracer();
        CursorFactory cursors = transaction.cursors();
        switch (direction) {
            case OUTGOING: {
                return RelationshipSelections.outgoingIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, (RelationshipFactory)this, (PageCursorTracer)cursorTracer);
            }
            case INCOMING: {
                return RelationshipSelections.incomingIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, (RelationshipFactory)this, (PageCursorTracer)cursorTracer);
            }
            case BOTH: {
                return RelationshipSelections.allIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, (RelationshipFactory)this, (PageCursorTracer)cursorTracer);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    private int[] relTypeIds(RelationshipType[] types, TokenRead token) {
        int[] ids = new int[types.length];
        int outIndex = 0;
        for (RelationshipType type : types) {
            int id = token.relationshipType(type.name());
            if (id == -1) continue;
            ids[outIndex++] = id;
        }
        if (outIndex != ids.length) {
            ids = Arrays.copyOf(ids, outIndex);
        }
        return ids;
    }

    private void singleNode(KernelTransaction transaction, NodeCursor nodes) {
        transaction.dataRead().singleNode(this.nodeId, nodes);
        if (!nodes.next()) {
            throw new NotFoundException((Throwable)new EntityNotFoundException(EntityType.NODE, this.nodeId));
        }
    }

    public Relationship relationship(long id, long startNodeId, int typeId, long endNodeId) {
        return this.internalTransaction.newRelationshipEntity(id, startNodeId, typeId, endNodeId);
    }
}

