/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.DelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;

public class ContractCheckingIndexProxy
extends DelegatingIndexProxy {
    private final AtomicReference<State> state;
    private final AtomicInteger openCalls;

    public ContractCheckingIndexProxy(IndexProxy delegate, boolean started) {
        super(delegate);
        this.state = new AtomicReference<State>(started ? State.STARTED : State.INIT);
        this.openCalls = new AtomicInteger(0);
    }

    @Override
    public void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            try {
                super.start();
            }
            finally {
                this.state.set(State.STARTED);
            }
        } else {
            throw new IllegalStateException("An IndexProxy can only be started once");
        }
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, PageCursorTracer cursorTracer) {
        if (IndexUpdateMode.ONLINE == mode) {
            this.openCall("update");
            return new DelegatingIndexUpdater(super.newUpdater(mode, cursorTracer)){

                @Override
                public void close() throws IndexEntryConflictException {
                    try {
                        this.delegate.close();
                    }
                    finally {
                        ContractCheckingIndexProxy.this.closeCall();
                    }
                }
            };
        }
        return super.newUpdater(mode, cursorTracer);
    }

    @Override
    public void force(IOLimiter ioLimiter, PageCursorTracer cursorTracer) throws IOException {
        if (this.tryOpenCall()) {
            try {
                super.force(ioLimiter, cursorTracer);
            }
            finally {
                this.closeCall();
            }
        }
    }

    @Override
    public void drop() {
        if (this.state.compareAndSet(State.INIT, State.CLOSED)) {
            super.drop();
            return;
        }
        if (State.STARTING == this.state.get()) {
            throw new IllegalStateException("Concurrent drop while creating index");
        }
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.waitOpenCallsToClose();
            super.drop();
            return;
        }
        throw new IllegalStateException("IndexProxy already closed");
    }

    @Override
    public void close(PageCursorTracer cursorTracer) throws IOException {
        if (this.state.compareAndSet(State.INIT, State.CLOSED)) {
            super.close(cursorTracer);
            return;
        }
        if (this.state.compareAndSet(State.STARTING, State.CLOSED)) {
            throw new IllegalStateException("Concurrent close while creating index");
        }
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.waitOpenCallsToClose();
            super.close(cursorTracer);
            return;
        }
        throw new IllegalStateException("IndexProxy already closed");
    }

    private void waitOpenCallsToClose() {
        while (this.openCalls.intValue() > 0) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    private void openCall(String name) {
        if (State.STARTED == this.state.get()) {
            this.openCalls.incrementAndGet();
            if (State.CLOSED == this.state.get()) {
                throw new IllegalStateException("Cannot call " + name + "() after index has been closed");
            }
        } else {
            throw new IllegalStateException("Cannot call " + name + "() when index state is " + (Object)((Object)this.state.get()));
        }
    }

    private boolean tryOpenCall() {
        if (State.STARTED == this.state.get()) {
            this.openCalls.incrementAndGet();
            if (State.STARTED == this.state.get()) {
                return true;
            }
            this.openCalls.decrementAndGet();
        }
        return false;
    }

    private void closeCall() {
        this.openCalls.decrementAndGet();
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        CLOSED;

    }
}

