/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;

public class DatabasePageCache
implements PageCache {
    private final PageCache globalPageCache;
    private final CopyOnWriteArrayList<PagedFile> databasePagedFiles = new CopyOnWriteArrayList();
    private final VersionContextSupplier versionContextSupplier;
    private boolean closed;

    public DatabasePageCache(PageCache globalPageCache, VersionContextSupplier versionContextSupplier) {
        Objects.requireNonNull(globalPageCache);
        Objects.requireNonNull(versionContextSupplier);
        this.globalPageCache = globalPageCache;
        this.versionContextSupplier = versionContextSupplier;
    }

    public PagedFile map(File file, VersionContextSupplier versionContextSupplier, int pageSize, ImmutableSet<OpenOption> openOptions) throws IOException {
        PagedFile pagedFile = this.globalPageCache.map(file, versionContextSupplier, pageSize, openOptions);
        DatabasePageFile databasePageFile = new DatabasePageFile(pagedFile, this.databasePagedFiles);
        this.databasePagedFiles.add(databasePageFile);
        return databasePageFile;
    }

    public Optional<PagedFile> getExistingMapping(File file) throws IOException {
        File canonicalFile = file.getCanonicalFile();
        return this.databasePagedFiles.stream().filter(pagedFile -> pagedFile.file().equals(canonicalFile)).findFirst();
    }

    public List<PagedFile> listExistingMappings() {
        return new ArrayList<PagedFile>(this.databasePagedFiles);
    }

    public void flushAndForce() throws IOException {
        for (PagedFile pagedFile : this.databasePagedFiles) {
            pagedFile.flushAndForce();
        }
    }

    public void flushAndForce(IOLimiter limiter) throws IOException {
        for (PagedFile pagedFile : this.databasePagedFiles) {
            pagedFile.flushAndForce(limiter);
        }
    }

    public synchronized void close() {
        if (this.closed) {
            throw new IllegalStateException("Database page cache was already closed");
        }
        for (PagedFile pagedFile : this.databasePagedFiles) {
            pagedFile.close();
        }
        this.databasePagedFiles.clear();
        this.closed = true;
    }

    public int pageSize() {
        return this.globalPageCache.pageSize();
    }

    public long maxCachedPages() {
        return this.globalPageCache.maxCachedPages();
    }

    public VersionContextSupplier versionContextSupplier() {
        return this.versionContextSupplier;
    }

    private static class DatabasePageFile
    implements PagedFile {
        private final PagedFile delegate;
        private final List<PagedFile> databaseFiles;

        DatabasePageFile(PagedFile delegate, List<PagedFile> databaseFiles) {
            this.delegate = delegate;
            this.databaseFiles = databaseFiles;
        }

        public PageCursor io(long pageId, int pf_flags, PageCursorTracer tracer) throws IOException {
            return this.delegate.io(pageId, pf_flags, tracer);
        }

        public int pageSize() {
            return this.delegate.pageSize();
        }

        public long fileSize() throws IOException {
            return this.delegate.fileSize();
        }

        public File file() {
            return this.delegate.file();
        }

        public void flushAndForce() throws IOException {
            this.delegate.flushAndForce();
        }

        public void flushAndForce(IOLimiter limiter) throws IOException {
            this.delegate.flushAndForce(limiter);
        }

        public long getLastPageId() throws IOException {
            return this.delegate.getLastPageId();
        }

        public void close() {
            this.delegate.close();
            this.databaseFiles.remove(this);
        }

        public void setDeleteOnClose(boolean deleteOnClose) {
            this.delegate.setDeleteOnClose(deleteOnClose);
        }

        public boolean isDeleteOnClose() {
            return this.delegate.isDeleteOnClose();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabasePageFile that = (DatabasePageFile)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }
    }
}

