/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.index.label.LabelScanReader;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.storageengine.api.StorageEntityScanCursor;

class LabelScanViewIdIterator<CURSOR extends StorageEntityScanCursor>
implements EntityIdIterator {
    private final int[] labelIds;
    private final LabelScanReader labelScanReader;
    private final CURSOR entityCursor;
    private PrimitiveLongResourceIterator idIterator;
    private long lastReturnedId = -1L;

    LabelScanViewIdIterator(LabelScanReader labelScanReader, int[] labelIds, CURSOR entityCursor) {
        this.labelScanReader = labelScanReader;
        this.entityCursor = entityCursor;
        this.idIterator = labelScanReader.nodesWithAnyOfLabels(labelIds);
        this.labelIds = labelIds;
    }

    public void close() {
        this.idIterator.close();
    }

    public boolean hasNext() {
        return this.idIterator.hasNext();
    }

    public long next() {
        long next = this.idIterator.next();
        this.entityCursor.single(next);
        this.entityCursor.next();
        this.lastReturnedId = next;
        return next;
    }

    @Override
    public void invalidateCache() {
        this.idIterator.close();
        this.idIterator = this.labelScanReader.nodesWithAnyOfLabels(this.lastReturnedId, this.labelIds);
    }
}

