/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class SchemaAndIndexingFileIndexListing {
    private static final Function<File, StoreFileMetadata> toStoreFileMetadata = file -> new StoreFileMetadata(file, 1);
    private final LabelScanStore labelScanStore;
    private final IndexingService indexingService;

    SchemaAndIndexingFileIndexListing(LabelScanStore labelScanStore, IndexingService indexingService) {
        this.labelScanStore = labelScanStore;
        this.indexingService = indexingService;
    }

    public LongSet getIndexIds() {
        return this.indexingService.getIndexIds();
    }

    Resource gatherSchemaIndexFiles(Collection<StoreFileMetadata> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.indexingService.snapshotIndexFiles();
        this.getSnapshotFilesMetadata(snapshot, targetFiles);
        return snapshot;
    }

    Resource gatherLabelScanStoreFiles(Collection<StoreFileMetadata> targetFiles) {
        ResourceIterator snapshot = this.labelScanStore.snapshotStoreFiles();
        this.getSnapshotFilesMetadata((ResourceIterator<File>)snapshot, targetFiles);
        return snapshot;
    }

    private void getSnapshotFilesMetadata(ResourceIterator<File> snapshot, Collection<StoreFileMetadata> targetFiles) {
        snapshot.stream().map(toStoreFileMetadata).forEach(targetFiles::add);
    }
}

