/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.monitoring.Monitors;

public class ReadOnlyTransactionStore
implements Lifecycle,
LogicalTransactionStore {
    private final LifeSupport life = new LifeSupport();
    private final LogicalTransactionStore physicalStore;

    public ReadOnlyTransactionStore(PageCache pageCache, FileSystemAbstraction fs, DatabaseLayout fromDatabaseLayout, Config config, Monitors monitors) throws IOException {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder(fromDatabaseLayout, fs, pageCache).withLogEntryReader((LogEntryReader)logEntryReader).withConfig(config).build();
        this.physicalStore = new PhysicalLogicalTransactionStore(logFiles, transactionMetadataCache, (LogEntryReader)logEntryReader, monitors, true);
    }

    @Override
    public TransactionCursor getTransactions(long transactionIdToStartFrom) throws IOException {
        return this.physicalStore.getTransactions(transactionIdToStartFrom);
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return this.physicalStore.getTransactions(position);
    }

    @Override
    public TransactionCursor getTransactionsInReverseOrder(LogPosition backToPosition) throws IOException {
        return this.physicalStore.getTransactionsInReverseOrder(backToPosition);
    }

    public void init() {
        this.life.init();
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
    }
}

