/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DatabaseConfig;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.storemigration.DatabaseMigrator;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class DatabaseMigratorFactory {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogService logService;
    private final PageCache pageCache;
    private final JobScheduler jobScheduler;
    private final NamedDatabaseId namedDatabaseId;

    public DatabaseMigratorFactory(FileSystemAbstraction fs, Config config, LogService logService, PageCache pageCache, JobScheduler jobScheduler, NamedDatabaseId namedDatabaseId) {
        this.fs = fs;
        this.config = config;
        this.logService = logService;
        this.pageCache = pageCache;
        this.jobScheduler = jobScheduler;
        this.namedDatabaseId = namedDatabaseId;
    }

    public DatabaseMigrator createDatabaseMigrator(DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, DependencyResolver dependencies) {
        DatabaseConfig dbConfig = new DatabaseConfig(this.config, this.namedDatabaseId);
        LegacyTransactionLogsLocator logsLocator = new LegacyTransactionLogsLocator(dbConfig, databaseLayout);
        return new DatabaseMigrator(this.fs, dbConfig, this.logService, dependencies, this.pageCache, this.jobScheduler, databaseLayout, logsLocator, storageEngineFactory);
    }
}

