/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageReader;

public class DefaultThreadSafeCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;

    public DefaultThreadSafeCursors(StorageReader storageReader) {
        super(new ConcurrentLinkedQueue<DefaultCursors.CloseableStacktrace>());
        this.storageReader = storageReader;
    }

    public DefaultNodeCursor allocateNodeCursor() {
        return this.trace(new DefaultNodeCursor(DefaultNodeCursor::release, this.storageReader.allocateNodeCursor()));
    }

    public FullAccessNodeCursor allocateFullAccessNodeCursor() {
        return this.trace(new FullAccessNodeCursor(DefaultNodeCursor::release, this.storageReader.allocateNodeCursor()));
    }

    public DefaultRelationshipScanCursor allocateRelationshipScanCursor() {
        return this.trace(new DefaultRelationshipScanCursor(DefaultRelationshipScanCursor::release, this.storageReader.allocateRelationshipScanCursor(), this.allocateNodeCursor()));
    }

    public FullAccessRelationshipScanCursor allocateFullAccessRelationshipScanCursor() {
        return this.trace(new FullAccessRelationshipScanCursor(DefaultRelationshipScanCursor::release, this.storageReader.allocateRelationshipScanCursor(), this.allocateFullAccessNodeCursor()));
    }

    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor() {
        return this.trace(new DefaultRelationshipTraversalCursor(DefaultRelationshipTraversalCursor::release, this.storageReader.allocateRelationshipTraversalCursor(), this.allocateNodeCursor()));
    }

    public PropertyCursor allocatePropertyCursor() {
        return this.trace(new DefaultPropertyCursor(DefaultPropertyCursor::release, this.storageReader.allocatePropertyCursor(), this.allocateFullAccessNodeCursor(), this.allocateFullAccessRelationshipScanCursor()));
    }

    public PropertyCursor allocateFullAccessPropertyCursor() {
        return this.trace(new FullAccessPropertyCursor(DefaultPropertyCursor::release, this.storageReader.allocatePropertyCursor(), this.allocateFullAccessNodeCursor(), this.allocateFullAccessRelationshipScanCursor()));
    }

    public RelationshipGroupCursor allocateRelationshipGroupCursor() {
        return this.trace(new DefaultRelationshipGroupCursor(DefaultRelationshipGroupCursor::release, this.storageReader.allocateRelationshipGroupCursor(), this.allocateRelationshipTraversalCursor()));
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor() {
        return this.trace(new DefaultNodeValueIndexCursor(DefaultNodeValueIndexCursor::release, this.allocateNodeCursor()));
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor() {
        return this.trace(new DefaultNodeLabelIndexCursor(DefaultNodeLabelIndexCursor::release, this.allocateNodeCursor()));
    }

    public RelationshipIndexCursor allocateRelationshipIndexCursor() {
        return this.trace(new DefaultRelationshipIndexCursor(DefaultRelationshipIndexCursor::release, this.allocateRelationshipScanCursor()));
    }

    public void close() {
        this.assertClosed();
        this.storageReader.close();
    }
}

