/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.EntityIndexSeekClient;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.values.storable.Value;

final class DefaultRelationshipIndexCursor
extends IndexCursor<IndexProgressor>
implements RelationshipIndexCursor,
EntityIndexSeekClient {
    private final CursorPool<DefaultRelationshipIndexCursor> pool;
    private final DefaultRelationshipScanCursor relationshipScanCursor;
    private Read read;
    private long relationship;
    private float score;
    private AccessMode accessMode;
    private int[] propertyIds;
    private boolean shortcutSecurity;

    DefaultRelationshipIndexCursor(CursorPool<DefaultRelationshipIndexCursor> pool, DefaultRelationshipScanCursor relationshipScanCursor) {
        this.pool = pool;
        this.relationshipScanCursor = relationshipScanCursor;
        this.relationship = -1L;
        this.score = Float.NaN;
    }

    @Override
    public void setRead(Read read) {
        this.read = read;
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues, boolean indexIncludesTransactionState) {
        assert (query != null && query.length > 0);
        super.initialize(progressor);
        if (indexOrder != IndexOrder.NONE) {
            throw new IllegalArgumentException("The relationship index cursor does not yet support index orders other than IndexOrder.NONE, but IndexOrder." + indexOrder + " was requested.");
        }
        if (needsValues) {
            throw new IllegalArgumentException("This relationship index cursor was told to fetch the values of the index entries, but this functionality has not been implemented.");
        }
        if (!indexIncludesTransactionState && this.read.hasTxStateWithChanges()) {
            SilentTokenNameLookup tokenNameLookup = new SilentTokenNameLookup(this.read.ktx.tokenRead());
            String index = descriptor.userDescription((TokenNameLookup)tokenNameLookup);
            throw new IllegalStateException("There is transaction state in this transaction, and the index (" + index + ") does not take transaction state into account. This means that the relationship index cursor has to account for the transaction state, but this has not been implemented.");
        }
        this.shortcutSecurity = this.setupSecurity(descriptor, query);
    }

    public boolean acceptEntity(long reference, float score, Value ... values) {
        if (!this.allows(reference)) {
            return false;
        }
        this.relationship = reference;
        this.score = score;
        return true;
    }

    private boolean allows(long reference) {
        if (this.shortcutSecurity) {
            return true;
        }
        this.read.singleRelationship(reference, this.relationshipScanCursor);
        if (!this.relationshipScanCursor.next()) {
            return false;
        }
        int relType = this.relationshipScanCursor.type();
        for (int prop : this.propertyIds) {
            if (this.accessMode.allowsReadRelationshipProperty(() -> relType, prop)) continue;
            return false;
        }
        return true;
    }

    private boolean setupSecurity(IndexDescriptor descriptor, IndexQuery[] query) {
        if (this.accessMode == null) {
            this.accessMode = this.read.ktx.securityContext().mode();
        }
        this.propertyIds = descriptor.schema().getPropertyIds();
        for (int relType : descriptor.schema().getEntityTokenIds()) {
            if (this.accessMode.allowsTraverseRelType(relType)) continue;
            return false;
        }
        if (!this.accessMode.allowsTraverseAllLabels()) {
            return false;
        }
        for (int propId : this.propertyIds) {
            if (this.accessMode.allowsReadPropertyAllRelTypes(propId)) continue;
            return false;
        }
        return true;
    }

    public boolean needsValues() {
        return false;
    }

    public void relationship(RelationshipScanCursor cursor) {
        this.read.singleRelationship(this.relationship, cursor);
    }

    public void sourceNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship index cursor.");
    }

    public void targetNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship index cursor.");
    }

    public int type() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship type in the relationship index cursor.");
    }

    public long sourceNodeReference() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship index cursor.");
    }

    public long targetNodeReference() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship index cursor.");
    }

    public long relationshipReference() {
        return this.relationship;
    }

    public boolean next() {
        boolean next = super.innerNext();
        if (this.tracer != null && next) {
            this.tracer.onRelationship(this.relationship);
        }
        return next;
    }

    public float score() {
        return this.score;
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.accessMode = null;
            this.relationship = -1L;
            this.score = Float.NaN;
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    public void release() {
        this.relationshipScanCursor.close();
        this.relationshipScanCursor.release();
    }
}

