/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.internal.unsafe.NativeMemoryAllocationRefusedError;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.util.Preconditions;

public class UnsafeDirectByteBufferAllocator
implements ByteBufferFactory.Allocator {
    private final MemoryAllocationTracker memoryAllocationTracker;
    private final List<ByteBuffer> allocations = new ArrayList<ByteBuffer>();
    private boolean closed;

    public UnsafeDirectByteBufferAllocator(MemoryAllocationTracker memoryAllocationTracker) {
        this.memoryAllocationTracker = memoryAllocationTracker;
    }

    public synchronized ByteBuffer allocate(int bufferSize) {
        this.assertOpen();
        try {
            ByteBuffer byteBuffer = ByteBuffers.allocateDirect((int)bufferSize);
            this.allocations.add(byteBuffer);
            this.memoryAllocationTracker.allocated((long)bufferSize);
            return byteBuffer;
        }
        catch (NativeMemoryAllocationRefusedError allocationRefusedError) {
            return ByteBuffers.allocate((int)bufferSize);
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.allocations.forEach(buffer -> {
                int capacity = buffer.capacity();
                this.memoryAllocationTracker.deallocated((long)capacity);
                ByteBuffers.releaseBuffer((ByteBuffer)buffer);
            });
            this.closed = true;
        }
    }

    private void assertOpen() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Already closed");
    }
}

