/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.index.schema.FilteringNativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeDistinctValuesProgressor;
import org.neo4j.kernel.impl.index.schema.NativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

abstract class NativeIndexReader<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements IndexReader {
    protected final IndexDescriptor descriptor;
    final IndexLayout<KEY, VALUE> layout;
    final GBPTree<KEY, VALUE> tree;

    NativeIndexReader(GBPTree<KEY, VALUE> tree, IndexLayout<KEY, VALUE> layout, IndexDescriptor descriptor) {
        this.tree = tree;
        this.layout = layout;
        this.descriptor = descriptor;
    }

    public void close() {
    }

    public IndexSampler createSampler() {
        FullScanNonUniqueIndexSampler sampler = new FullScanNonUniqueIndexSampler(this.tree, this.layout);
        return () -> {
            try {
                return sampler.result();
            }
            catch (UncheckedIOException e) {
                if (ExceptionUtils.getRootCause((Throwable)e) instanceof FileIsNotMappedException) {
                    IndexNotFoundKernelException exception = new IndexNotFoundKernelException("Index dropped while sampling.");
                    exception.addSuppressed((Throwable)e);
                    throw exception;
                }
                throw e;
            }
        };
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        long l;
        block10: {
            NativeIndexKey treeKeyFrom = (NativeIndexKey)((Object)this.layout.newKey());
            NativeIndexKey treeKeyTo = (NativeIndexKey)((Object)this.layout.newKey());
            treeKeyFrom.initialize(nodeId);
            treeKeyTo.initialize(nodeId);
            for (int i = 0; i < propertyValues.length; ++i) {
                treeKeyFrom.initFromValue(i, propertyValues[i], NativeIndexKey.Inclusion.NEUTRAL);
                treeKeyTo.initFromValue(i, propertyValues[i], NativeIndexKey.Inclusion.NEUTRAL);
            }
            Seeker seeker = this.tree.seek((Object)treeKeyFrom, (Object)treeKeyTo);
            try {
                long count = 0L;
                while (seeker.next()) {
                    if (((NativeIndexKey)((Object)seeker.key())).getEntityId() != nodeId) continue;
                    ++count;
                }
                l = count;
                if (seeker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (seeker != null) {
                        try {
                            seeker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            seeker.close();
        }
        return l;
    }

    public void query(QueryContext context, IndexProgressor.EntityValueClient cursor, IndexOrder indexOrder, boolean needsValues, IndexQuery ... predicates) {
        this.validateQuery(indexOrder, predicates);
        NativeIndexKey treeKeyFrom = (NativeIndexKey)((Object)this.layout.newKey());
        NativeIndexKey treeKeyTo = (NativeIndexKey)((Object)this.layout.newKey());
        this.initializeFromToKeys(treeKeyFrom, treeKeyTo);
        boolean needFilter = this.initializeRangeForQuery(treeKeyFrom, treeKeyTo, predicates);
        this.startSeekForInitializedRange(cursor, treeKeyFrom, treeKeyTo, predicates, indexOrder, needFilter, needsValues);
    }

    void initializeFromToKeys(KEY treeKeyFrom, KEY treeKeyTo) {
        ((NativeIndexKey)((Object)treeKeyFrom)).initialize(Long.MIN_VALUE);
        ((NativeIndexKey)((Object)treeKeyTo)).initialize(Long.MAX_VALUE);
    }

    public abstract boolean hasFullValuePrecision(IndexQuery ... var1);

    public void distinctValues(IndexProgressor.EntityValueClient client, NodePropertyAccessor ignore, boolean needsValues) {
        NativeIndexKey lowest = (NativeIndexKey)((Object)this.layout.newKey());
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValuesAsLowest();
        NativeIndexKey highest = (NativeIndexKey)((Object)this.layout.newKey());
        highest.initialize(Long.MAX_VALUE);
        highest.initValuesAsHighest();
        try {
            Seeker seeker = this.tree.seek((Object)lowest, (Object)highest);
            client.initialize(this.descriptor, new NativeDistinctValuesProgressor<KEY, VALUE>(seeker, client, this.layout, this.layout::compareValue), new IndexQuery[0], IndexOrder.NONE, needsValues, false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    abstract void validateQuery(IndexOrder var1, IndexQuery[] var2);

    abstract boolean initializeRangeForQuery(KEY var1, KEY var2, IndexQuery[] var3);

    void startSeekForInitializedRange(IndexProgressor.EntityValueClient client, KEY treeKeyFrom, KEY treeKeyTo, IndexQuery[] query, IndexOrder indexOrder, boolean needFilter, boolean needsValues) {
        if (this.isEmptyRange(treeKeyFrom, treeKeyTo)) {
            client.initialize(this.descriptor, IndexProgressor.EMPTY, query, indexOrder, needsValues, false);
            return;
        }
        try {
            Seeker<KEY, VALUE> seeker = this.makeIndexSeeker(treeKeyFrom, treeKeyTo, indexOrder);
            IndexProgressor hitProgressor = this.getIndexProgressor(seeker, client, needFilter, query);
            client.initialize(this.descriptor, hitProgressor, query, indexOrder, needsValues, false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Seeker<KEY, VALUE> makeIndexSeeker(KEY treeKeyFrom, KEY treeKeyTo, IndexOrder indexOrder) throws IOException {
        if (indexOrder == IndexOrder.DESCENDING) {
            KEY tmpKey = treeKeyFrom;
            treeKeyFrom = treeKeyTo;
            treeKeyTo = tmpKey;
        }
        return this.tree.seek(treeKeyFrom, treeKeyTo);
    }

    private IndexProgressor getIndexProgressor(Seeker<KEY, VALUE> seeker, IndexProgressor.EntityValueClient client, boolean needFilter, IndexQuery[] query) {
        return needFilter ? new FilteringNativeHitIndexProgressor<KEY, VALUE>(seeker, client, query) : new NativeHitIndexProgressor<KEY, VALUE>(seeker, client);
    }

    private boolean isEmptyRange(KEY treeKeyFrom, KEY treeKeyTo) {
        return this.layout.compare(treeKeyFrom, treeKeyTo) > 0;
    }
}

