/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;

abstract class NativeIndexProvider<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue, LAYOUT extends IndexLayout<KEY, VALUE>>
extends IndexProvider {
    protected final PageCache pageCache;
    protected final FileSystemAbstraction fs;
    protected final IndexProvider.Monitor monitor;
    protected final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    protected final boolean readOnly;

    protected NativeIndexProvider(IndexProviderDescriptor descriptor, IndexDirectoryStructure.Factory directoryStructureFactory, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(descriptor, directoryStructureFactory);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    abstract LAYOUT layout(IndexDescriptor var1, File var2);

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, TokenNameLookup tokenNameLookup) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        IndexFiles.Directory indexFiles = new IndexFiles.Directory(this.fs, this.directoryStructure(), descriptor.getId());
        return this.newIndexPopulator(indexFiles, this.layout(descriptor, null), descriptor, bufferFactory, tokenNameLookup);
    }

    protected abstract IndexPopulator newIndexPopulator(IndexFiles var1, LAYOUT var2, IndexDescriptor var3, ByteBufferFactory var4, TokenNameLookup var5);

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
        IndexFiles.Directory indexFiles = new IndexFiles.Directory(this.fs, this.directoryStructure(), descriptor.getId());
        return this.newIndexAccessor(indexFiles, this.layout(descriptor, ((IndexFiles)indexFiles).getStoreFile()), descriptor, this.readOnly, tokenNameLookup);
    }

    protected abstract IndexAccessor newIndexAccessor(IndexFiles var1, LAYOUT var2, IndexDescriptor var3, boolean var4, TokenNameLookup var5) throws IOException;

    public String getPopulationFailure(IndexDescriptor descriptor) {
        try {
            String failureMessage = NativeIndexes.readFailureMessage(this.pageCache, this.storeFile(descriptor));
            return (String)StringUtils.defaultIfEmpty((CharSequence)failureMessage, (CharSequence)"");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor) {
        try {
            return NativeIndexes.readState(this.pageCache, this.storeFile(descriptor));
        }
        catch (IOException | MetadataMismatchException e) {
            this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private File storeFile(IndexDescriptor descriptor) {
        IndexFiles.Directory indexFiles = new IndexFiles.Directory(this.fs, this.directoryStructure(), descriptor.getId());
        return ((IndexFiles)indexFiles).getStoreFile();
    }
}

