/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.SystemGraphDbmsModel;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

public class SystemDbDatabaseIdRepository
implements DatabaseIdRepository {
    private final DatabaseManager<?> databaseManager;
    private final Executor executor;

    public SystemDbDatabaseIdRepository(DatabaseManager<?> databaseManager, JobScheduler jobScheduler) {
        this.databaseManager = databaseManager;
        this.executor = jobScheduler.executor(Group.DATABASE_ID_REPOSITORY);
    }

    @Override
    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName normalizedDatabaseName) {
        String databaseName = normalizedDatabaseName.name();
        return SystemDbDatabaseIdRepository.runAsync(() -> this.get0("name", databaseName), this.executor);
    }

    @Override
    public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
        return SystemDbDatabaseIdRepository.runAsync(() -> this.get0("uuid", databaseId.uuid().toString()), this.executor);
    }

    private static <T> T runAsync(Supplier<T> supplier, Executor executor) {
        try {
            return CompletableFuture.supplyAsync(supplier, executor).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<NamedDatabaseId> get0(String propertyKey, String propertyValue) {
        DatabaseContext context = (DatabaseContext)this.databaseManager.getDatabaseContext(NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new DatabaseNotFoundException("system"));
        GraphDatabaseFacade db = context.databaseFacade();
        try (Transaction tx = db.beginTx();){
            Node node = tx.findNode(SystemGraphDbmsModel.DATABASE_LABEL, propertyKey, (Object)propertyValue);
            if (node == null) {
                Optional<NamedDatabaseId> optional2 = Optional.empty();
                return optional2;
            }
            String databaseName = this.getPropertyOnNode(node, "name", propertyValue);
            String databaseUuid = this.getPropertyOnNode(node, "uuid", propertyValue);
            Optional<NamedDatabaseId> optional = Optional.of(new NamedDatabaseId(databaseName, UUID.fromString(databaseUuid)));
            return optional;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getPropertyOnNode(Node node, String key, String database) {
        Object value = node.getProperty(key);
        if (value == null) {
            throw new IllegalStateException(String.format("Database has no %s: %s.", key, database));
        }
        if (!(value instanceof String)) {
            throw new IllegalStateException(String.format("Database has non String %s: %s.", key, database));
        }
        return (String)value;
    }
}

