/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Collection;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class MultipleIndexesException
extends SchemaKernelException {
    private final SchemaDescriptor descriptor;
    private final Collection<IndexDescriptor> indexes;
    private static final String message = "Multiple indexes were found for %s. Try using an index name instead: %s.";

    public MultipleIndexesException(SchemaDescriptor descriptor, Collection<IndexDescriptor> indexes) {
        super((Status)Status.Schema.IndexMultipleFound, MultipleIndexesException.getUserMessage(TokenNameLookup.idTokenNameLookup, descriptor, indexes));
        this.descriptor = descriptor;
        this.indexes = indexes;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return MultipleIndexesException.getUserMessage(tokenNameLookup, this.descriptor, this.indexes);
    }

    private static String getUserMessage(TokenNameLookup tokenNameLookup, SchemaDescriptor descriptor, Collection<IndexDescriptor> indexes) {
        return String.format(message, descriptor.userDescription(tokenNameLookup), Iterators.toString(indexes.iterator(), IndexDescriptor::getName, (int)5));
    }
}

