/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialConfigVisitor;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.Value;

class GenericBlockBasedIndexPopulator
extends BlockBasedIndexPopulator<GenericKey, NativeIndexValue> {
    private final IndexSpecificSpaceFillingCurveSettings spatialSettings;
    private final SpaceFillingCurveConfiguration configuration;

    GenericBlockBasedIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, IndexFiles indexFiles, IndexLayout<GenericKey, NativeIndexValue> layout, IndexProvider.Monitor monitor, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettings spatialSettings, SpaceFillingCurveConfiguration configuration, boolean archiveFailedIndex, ByteBufferFactory bufferFactory, TokenNameLookup tokenNameLookup) {
        super(pageCache, fs, indexFiles, layout, monitor, descriptor, archiveFailedIndex, bufferFactory, tokenNameLookup);
        this.spatialSettings = spatialSettings;
        this.configuration = configuration;
    }

    @Override
    NativeIndexReader<GenericKey, NativeIndexValue> newReader() {
        return new GenericNativeIndexReader((GBPTree<GenericKey, NativeIndexValue>)this.tree, this.layout, this.descriptor, this.spatialSettings, this.configuration);
    }

    public Map<String, Value> indexConfig() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        this.spatialSettings.visitIndexSpecificSettings(new SpatialConfigVisitor(map));
        return map;
    }
}

