/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Clock;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.dbms.database.DatabaseConfig;
import org.neo4j.dbms.database.DatabasePageCache;
import org.neo4j.function.Factory;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.LoggingMonitor;
import org.neo4j.internal.index.label.NativeLabelScanStore;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailability;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.DatabaseFileHelper;
import org.neo4j.kernel.database.DatabaseKernelModule;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.DatabaseTransactionLogModule;
import org.neo4j.kernel.database.DefaultForceOperation;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.diagnostics.providers.DbmsDiagnosticsManager;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.transaction.monitor.KernelTransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.KernelTransactionMonitorScheduler;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.FacadeKernelTransactionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.pagecache.PageCacheStartMetricsReporter;
import org.neo4j.kernel.impl.pagecache.PageCacheStopMetricsReporter;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.store.stats.DatabaseEntityCounters;
import org.neo4j.kernel.impl.storemigration.DatabaseMigratorFactory;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointerLifecycle;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.kernel.impl.transaction.log.reverse.ReverseTransactionCursorLoggingMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.state.DatabaseFileListing;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.internal.locker.LockerLifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.LoggingLogTailScannerMonitor;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ReentrantLockService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.DatabaseLog;
import org.neo4j.logging.internal.DatabaseLogProvider;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.DatabaseEventListeners;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.NodeLabelUpdateListener;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.VisibleForTesting;

public class Database
extends LifecycleAdapter {
    private final Monitors parentMonitors;
    private final DependencyResolver globalDependencies;
    private final PageCache globalPageCache;
    private final Log msgLog;
    private final DatabaseLogService databaseLogService;
    private final DatabaseLogProvider internalLogProvider;
    private final DatabaseLogProvider userLogProvider;
    private final TokenNameLookup tokenNameLookup;
    private final TokenHolders tokenHolders;
    private final StatementLocksFactory statementLocksFactory;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final IdGeneratorFactory idGeneratorFactory;
    private final JobScheduler scheduler;
    private final LockService lockService;
    private final FileSystemAbstraction fs;
    private final DatabaseTransactionStats transactionStats;
    private final CommitProcessFactory commitProcessFactory;
    private final ConstraintSemantics constraintSemantics;
    private final GlobalProcedures globalProcedures;
    private final IOLimiter ioLimiter;
    private final SystemNanoClock clock;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final Locks locks;
    private final DatabaseEventListeners eventListeners;
    private final DatabaseTracer databaseTracer;
    private final PageCursorTracerSupplier pageCursorTracerSupplier;
    private final LockTracer lockTracer;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final LeaseService leaseService;
    private Dependencies databaseDependencies;
    private LifeSupport life;
    private IndexProviderMap indexProviderMap;
    private DatabaseHealth databaseHealth;
    private final DatabaseAvailabilityGuard databaseAvailabilityGuard;
    private final DatabaseConfig databaseConfig;
    private final NamedDatabaseId namedDatabaseId;
    private final DatabaseLayout databaseLayout;
    private final boolean readOnly;
    private final IdController idController;
    private final DatabaseInfo databaseInfo;
    private final VersionContextSupplier versionContextSupplier;
    private AccessCapability accessCapability;
    private final StorageEngineFactory storageEngineFactory;
    private StorageEngine storageEngine;
    private QueryExecutionEngine executionEngine;
    private DatabaseKernelModule kernelModule;
    private final Iterable<ExtensionFactory<?>> extensionFactories;
    private final Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
    private final Factory<DatabaseHealth> databaseHealthFactory;
    private final QueryEngineProvider engineProvider;
    private volatile boolean started;
    private Monitors databaseMonitors;
    private DatabasePageCache databasePageCache;
    private CheckpointerLifecycle checkpointerLifecycle;
    private final GraphDatabaseFacade databaseFacade;
    private final FileLockerService fileLockerService;
    private final KernelTransactionFactory kernelTransactionFactory;
    private final DatabaseStartupController startupController;

    public Database(DatabaseCreationContext context) {
        this.namedDatabaseId = context.getNamedDatabaseId();
        this.databaseLayout = context.getDatabaseLayout();
        this.databaseConfig = context.getDatabaseConfig();
        this.idGeneratorFactory = context.getIdGeneratorFactory();
        this.tokenNameLookup = context.getTokenNameLookup();
        this.globalDependencies = context.getGlobalDependencies();
        this.scheduler = context.getScheduler();
        this.databaseLogService = context.getDatabaseLogService();
        this.storeCopyCheckPointMutex = context.getStoreCopyCheckPointMutex();
        this.internalLogProvider = context.getDatabaseLogService().getInternalLogProvider();
        this.userLogProvider = context.getDatabaseLogService().getUserLogProvider();
        this.tokenHolders = context.getTokenHolders();
        this.locks = context.getLocks();
        this.statementLocksFactory = context.getStatementLocksFactory();
        this.transactionEventListeners = context.getTransactionEventListeners();
        this.fs = context.getFs();
        this.transactionStats = context.getTransactionStats();
        this.databaseHealthFactory = context.getDatabaseHealthFactory();
        this.constraintSemantics = context.getConstraintSemantics();
        this.parentMonitors = context.getMonitors();
        this.globalProcedures = context.getGlobalProcedures();
        this.ioLimiter = context.getIoLimiter();
        this.clock = context.getClock();
        this.eventListeners = context.getDatabaseEventListeners();
        this.accessCapabilityFactory = context.getAccessCapabilityFactory();
        this.readOnly = (Boolean)this.databaseConfig.get(GraphDatabaseSettings.read_only);
        this.idController = context.getIdController();
        this.databaseInfo = context.getDatabaseInfo();
        this.versionContextSupplier = context.getVersionContextSupplier();
        this.extensionFactories = context.getExtensionFactories();
        this.watcherServiceFactory = context.getWatcherServiceFactory();
        this.engineProvider = context.getEngineProvider();
        this.msgLog = this.internalLogProvider.getLog(((Object)((Object)this)).getClass());
        this.lockService = new ReentrantLockService();
        this.commitProcessFactory = context.getCommitProcessFactory();
        this.globalPageCache = context.getPageCache();
        this.collectionsFactorySupplier = context.getCollectionsFactorySupplier();
        this.storageEngineFactory = context.getStorageEngineFactory();
        long availabilityGuardTimeout = ((Duration)this.databaseConfig.get(GraphDatabaseSettings.transaction_start_timeout)).toMillis();
        this.databaseAvailabilityGuard = context.getDatabaseAvailabilityGuardFactory().apply(availabilityGuardTimeout);
        this.databaseFacade = new GraphDatabaseFacade(this, this.databaseConfig, this.databaseInfo, this.databaseAvailabilityGuard);
        this.kernelTransactionFactory = new FacadeKernelTransactionFactory(this.databaseConfig, this.databaseFacade);
        Tracers globalTracers = context.getTracers();
        this.databaseTracer = globalTracers.getDatabaseTracer();
        this.pageCursorTracerSupplier = globalTracers.getPageCursorTracerSupplier();
        this.lockTracer = globalTracers.getLockTracer();
        this.fileLockerService = context.getFileLockerService();
        this.leaseService = context.getLeaseService();
        this.startupController = context.getStartupController();
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        try {
            this.databaseDependencies = new Dependencies(this.globalDependencies);
            this.databasePageCache = new DatabasePageCache(this.globalPageCache, this.versionContextSupplier);
            this.databaseMonitors = new Monitors(this.parentMonitors);
            this.life = new LifeSupport();
            this.life.add((Lifecycle)new LockerLifecycleAdapter(this.fileLockerService.createDatabaseLocker(this.fs, this.databaseLayout)));
            this.life.add((Lifecycle)this.databaseConfig);
            this.databaseHealth = (DatabaseHealth)this.databaseHealthFactory.newInstance();
            this.accessCapability = this.accessCapabilityFactory.newAccessCapability(this.databaseConfig);
            DatabaseAvailability databaseAvailability = new DatabaseAvailability(this.databaseAvailabilityGuard, this.transactionStats, (Clock)this.clock, this.getAwaitActiveTransactionDeadlineMillis());
            this.databaseDependencies.satisfyDependency((Object)this);
            this.databaseDependencies.satisfyDependency((Object)this.startupController);
            this.databaseDependencies.satisfyDependency((Object)this.databaseConfig);
            this.databaseDependencies.satisfyDependency((Object)this.databaseMonitors);
            this.databaseDependencies.satisfyDependency((Object)this.databaseLogService);
            this.databaseDependencies.satisfyDependency((Object)this.databasePageCache);
            this.databaseDependencies.satisfyDependency((Object)this.tokenHolders);
            this.databaseDependencies.satisfyDependency((Object)this.databaseFacade);
            this.databaseDependencies.satisfyDependency((Object)this.kernelTransactionFactory);
            this.databaseDependencies.satisfyDependency((Object)this.databaseHealth);
            this.databaseDependencies.satisfyDependency((Object)this.storeCopyCheckPointMutex);
            this.databaseDependencies.satisfyDependency((Object)this.transactionStats);
            this.databaseDependencies.satisfyDependency((Object)this.locks);
            this.databaseDependencies.satisfyDependency((Object)this.databaseAvailabilityGuard);
            this.databaseDependencies.satisfyDependency((Object)databaseAvailability);
            this.databaseDependencies.satisfyDependency((Object)this.idGeneratorFactory);
            this.databaseDependencies.satisfyDependency((Object)this.idController);
            this.databaseDependencies.satisfyDependency((Object)this.lockService);
            this.databaseDependencies.satisfyDependency((Object)this.versionContextSupplier);
            this.databaseDependencies.satisfyDependency((Object)this.databaseTracer);
            this.databaseDependencies.satisfyDependency((Object)this.lockTracer);
            RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.immediate();
            this.databaseDependencies.satisfyDependency((Object)recoveryCleanupWorkCollector);
            this.life.add((Lifecycle)new PageCacheStopMetricsReporter(this.pageCursorTracerSupplier));
            this.life.add((Lifecycle)new PageCacheLifecycle(this.databasePageCache));
            this.life.add((Lifecycle)this.initializeExtensions(this.databaseDependencies));
            DatabaseLayoutWatcher watcherService = this.watcherServiceFactory.apply(this.databaseLayout);
            this.life.add((Lifecycle)watcherService);
            this.databaseDependencies.satisfyDependency((Object)watcherService);
            this.upgradeStore(this.databaseConfig, this.databasePageCache);
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
            LogFiles logFiles = LogFilesBuilder.builder(this.databaseLayout, this.fs).withLogEntryReader((LogEntryReader)logEntryReader).withConfig(this.databaseConfig).withDependencies((DependencyResolver)this.databaseDependencies).withLogProvider((LogProvider)this.internalLogProvider).withDatabaseTracer(this.databaseTracer).build();
            this.databaseMonitors.addMonitorListener((Object)new LoggingLogFileMonitor(this.msgLog), new String[0]);
            this.databaseMonitors.addMonitorListener((Object)new LoggingLogTailScannerMonitor(this.internalLogProvider.getLog(LogTailScanner.class)), new String[0]);
            this.databaseMonitors.addMonitorListener((Object)new ReverseTransactionCursorLoggingMonitor(this.internalLogProvider.getLog(ReversedSingleFileTransactionCursor.class)), new String[0]);
            LogTailScanner tailScanner = new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, this.databaseMonitors, (Boolean)this.databaseConfig.get(GraphDatabaseSettings.fail_on_corrupted_log_files));
            LogVersionUpgradeChecker.check(tailScanner, this.databaseConfig);
            boolean storageExists = this.storageEngineFactory.storageExists(this.fs, this.databaseLayout, (PageCache)this.databasePageCache);
            if (storageExists) {
                Recovery.validateStoreId(tailScanner, this.storageEngineFactory.storeId(this.databaseLayout, (PageCache)this.databasePageCache));
            }
            Recovery.performRecovery(this.fs, this.databasePageCache, this.databaseConfig, this.databaseLayout, this.storageEngineFactory, (LogProvider)this.internalLogProvider, this.databaseMonitors, this.extensionFactories, Optional.of(tailScanner), new RecoveryStartupChecker(this.startupController, this.namedDatabaseId));
            DatabaseSchemaState databaseSchemaState = new DatabaseSchemaState((LogProvider)this.internalLogProvider);
            Supplier<IdController.ConditionSnapshot> transactionsSnapshotSupplier = () -> this.kernelModule.kernelTransactions().get();
            this.idController.initialize(transactionsSnapshotSupplier);
            this.storageEngine = this.storageEngineFactory.instantiate(this.fs, this.databaseLayout, (Config)this.databaseConfig, (PageCache)this.databasePageCache, this.tokenHolders, (SchemaState)databaseSchemaState, (ConstraintRuleAccessor)this.constraintSemantics, (IndexConfigCompleter)this.indexProviderMap, this.lockService, this.idGeneratorFactory, this.idController, this.databaseHealth, (LogProvider)this.internalLogProvider, recoveryCleanupWorkCollector, !storageExists);
            this.life.add((Lifecycle)this.storageEngine);
            this.life.add(this.storageEngine.schemaAndTokensLifecycle());
            this.life.add((Lifecycle)logFiles);
            NeoStoreIndexStoreView neoStoreIndexStoreView = new NeoStoreIndexStoreView(this.lockService, () -> ((StorageEngine)this.storageEngine).newReader());
            LabelScanStore labelScanStore = this.buildLabelIndex(this.databasePageCache, recoveryCleanupWorkCollector, this.storageEngine, neoStoreIndexStoreView, this.databaseMonitors);
            DynamicIndexStoreView indexStoreView = new DynamicIndexStoreView(neoStoreIndexStoreView, labelScanStore, this.lockService, () -> ((StorageEngine)this.storageEngine).newReader(), (LogProvider)this.internalLogProvider);
            IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore((PageCache)this.databasePageCache, this.databaseLayout, recoveryCleanupWorkCollector, this.readOnly);
            IndexingService indexingService = this.buildIndexingService(this.storageEngine, databaseSchemaState, indexStoreView, indexStatisticsStore);
            TransactionIdStore transactionIdStore = this.storageEngine.transactionIdStore();
            this.databaseDependencies.satisfyDependency((Object)transactionIdStore);
            this.databaseDependencies.satisfyDependency((Object)this.storageEngine.logVersionRepository());
            this.databaseDependencies.satisfyDependency((Object)this.storageEngine.countsAccessor());
            this.versionContextSupplier.init(() -> ((TransactionIdStore)transactionIdStore).getLastClosedTransactionId());
            DefaultForceOperation forceOperation = new DefaultForceOperation(indexingService, labelScanStore, this.storageEngine);
            DatabaseTransactionLogModule transactionLogModule = this.buildTransactionLogs(logFiles, this.databaseConfig, (LogProvider)this.internalLogProvider, this.scheduler, forceOperation, (LogEntryReader)logEntryReader, transactionIdStore, this.databaseMonitors);
            transactionLogModule.satisfyDependencies(this.databaseDependencies);
            DatabaseKernelModule kernelModule = this.buildKernel(logFiles, transactionLogModule.transactionAppender(), indexingService, databaseSchemaState, labelScanStore, this.storageEngine, transactionIdStore, this.databaseAvailabilityGuard, this.clock, indexStatisticsStore, this.databaseFacade, this.leaseService);
            kernelModule.satisfyDependencies(this.databaseDependencies);
            this.kernelModule = kernelModule;
            this.databaseDependencies.satisfyDependency((Object)databaseSchemaState);
            this.databaseDependencies.satisfyDependency((Object)logEntryReader);
            this.databaseDependencies.satisfyDependency((Object)this.storageEngine);
            this.databaseDependencies.satisfyDependency((Object)labelScanStore);
            this.databaseDependencies.satisfyDependency((Object)indexingService);
            this.databaseDependencies.satisfyDependency((Object)indexStoreView);
            this.databaseDependencies.satisfyDependency((Object)indexStatisticsStore);
            this.databaseDependencies.satisfyDependency((Object)this.indexProviderMap);
            this.databaseDependencies.satisfyDependency((Object)forceOperation);
            this.databaseDependencies.satisfyDependency((Object)new DatabaseEntityCounters(this.idGeneratorFactory, (CountsAccessor)this.databaseDependencies.resolveDependency(CountsAccessor.class)));
            QueryEngineProvider.SPI providerSpi = QueryEngineProvider.spi((LogProvider)this.internalLogProvider, this.databaseMonitors, this.scheduler, this.life, this.getKernel(), this.databaseConfig);
            this.executionEngine = QueryEngineProvider.initialize(this.databaseDependencies, this.databaseFacade, this.engineProvider, this.isSystem(), providerSpi);
            this.checkpointerLifecycle = new CheckpointerLifecycle(transactionLogModule.checkPointer(), (Health)this.databaseHealth);
            this.life.add((Lifecycle)this.databaseHealth);
            this.life.add((Lifecycle)this.databaseAvailabilityGuard);
            this.life.add((Lifecycle)databaseAvailability);
            this.life.add((Lifecycle)new PageCacheStartMetricsReporter(this.pageCursorTracerSupplier));
            this.life.setLast((Lifecycle)this.checkpointerLifecycle);
            ((DbmsDiagnosticsManager)this.databaseDependencies.resolveDependency(DbmsDiagnosticsManager.class)).dumpDatabaseDiagnostics(this);
            this.life.start();
            this.eventListeners.databaseStart(this.namedDatabaseId.name());
        }
        catch (Throwable e) {
            this.databaseAvailabilityGuard.startupFailure(e);
            this.msgLog.warn("Exception occurred while starting the database. Trying to stop already started components.", e);
            try {
                ThrowingAction.executeAll((ThrowingAction[])new ThrowingAction[]{() -> Database.safeLifeShutdown(this.life), () -> Database.safeStorageEngineClose(this.storageEngine)});
            }
            catch (Exception closeException) {
                this.msgLog.error("Couldn't close database after startup failure", (Throwable)closeException);
            }
            throw new RuntimeException(e);
        }
        this.databaseHealth.healed();
        this.started = true;
    }

    private LifeSupport initializeExtensions(Dependencies dependencies) {
        LifeSupport extensionsLife = new LifeSupport();
        extensionsLife.add((Lifecycle)new DatabaseExtensions(new DatabaseExtensionContext(this.databaseLayout, this.databaseInfo, (DependencySatisfier)dependencies), this.extensionFactories, dependencies, ExtensionFailureStrategies.fail()));
        this.indexProviderMap = (IndexProviderMap)extensionsLife.add((Lifecycle)new DefaultIndexProviderMap((DependencyResolver)dependencies, this.databaseConfig));
        dependencies.satisfyDependency((Object)this.indexProviderMap);
        extensionsLife.init();
        return extensionsLife;
    }

    private void upgradeStore(DatabaseConfig databaseConfig, DatabasePageCache databasePageCache) {
        new DatabaseMigratorFactory(this.fs, databaseConfig, (LogService)this.databaseLogService, databasePageCache, this.scheduler, this.namedDatabaseId).createDatabaseMigrator(this.databaseLayout, this.storageEngineFactory, (DependencyResolver)this.databaseDependencies).migrate();
    }

    private IndexingService buildIndexingService(StorageEngine storageEngine, DatabaseSchemaState databaseSchemaState, DynamicIndexStoreView indexStoreView, IndexStatisticsStore indexStatisticsStore) {
        return (IndexingService)this.life.add((Lifecycle)Database.buildIndexingService(storageEngine, databaseSchemaState, indexStoreView, indexStatisticsStore, this.databaseConfig, this.scheduler, this.indexProviderMap, this.tokenNameLookup, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexingService.Monitor)this.databaseMonitors.newMonitor(IndexingService.Monitor.class, new String[0]), this.readOnly));
    }

    public static IndexingService buildIndexingService(StorageEngine storageEngine, DatabaseSchemaState databaseSchemaState, DynamicIndexStoreView indexStoreView, IndexStatisticsStore indexStatisticsStore, Config config, JobScheduler jobScheduler, IndexProviderMap indexProviderMap, TokenNameLookup tokenNameLookup, LogProvider internalLogProvider, LogProvider userLogProvider, IndexingService.Monitor indexingServiceMonitor, boolean readOnly) {
        IndexingService indexingService = IndexingServiceFactory.createIndexingService(config, jobScheduler, indexProviderMap, indexStoreView, tokenNameLookup, Database.initialSchemaRulesLoader(storageEngine), internalLogProvider, userLogProvider, indexingServiceMonitor, databaseSchemaState, indexStatisticsStore, readOnly);
        storageEngine.addIndexUpdateListener((IndexUpdateListener)indexingService);
        return indexingService;
    }

    public boolean isSystem() {
        return this.namedDatabaseId.isSystemDatabase();
    }

    private LabelScanStore buildLabelIndex(PageCache pageCache, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, StorageEngine storageEngine, NeoStoreIndexStoreView neoStoreIndexStoreView, Monitors monitors) {
        return (LabelScanStore)this.life.add((Lifecycle)Database.buildLabelIndex(recoveryCleanupWorkCollector, storageEngine, neoStoreIndexStoreView, monitors, (LogProvider)this.internalLogProvider, pageCache, this.databaseLayout, this.fs, this.readOnly));
    }

    public static LabelScanStore buildLabelIndex(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, StorageEngine storageEngine, IndexStoreView indexStoreView, Monitors monitors, LogProvider logProvider, PageCache pageCache, DatabaseLayout databaseLayout, FileSystemAbstraction fs, boolean readOnly) {
        monitors.addMonitorListener((Object)new LoggingMonitor(logProvider.getLog(NativeLabelScanStore.class)), new String[0]);
        NativeLabelScanStore labelScanStore = new NativeLabelScanStore(pageCache, databaseLayout, fs, (FullStoreChangeStream)new FullLabelStream(indexStoreView), readOnly, monitors, recoveryCleanupWorkCollector);
        storageEngine.addNodeLabelUpdateListener((NodeLabelUpdateListener)labelScanStore);
        return labelScanStore;
    }

    private DatabaseTransactionLogModule buildTransactionLogs(LogFiles logFiles, Config config, LogProvider logProvider, JobScheduler scheduler, CheckPointerImpl.ForceOperation forceOperation, LogEntryReader logEntryReader, TransactionIdStore transactionIdStore, Monitors monitors) {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        LogPruningImpl logPruning = new LogPruningImpl(this.fs, logFiles, logProvider, new LogPruneStrategyFactory(), this.clock, config);
        LogRotationImpl logRotation = new LogRotationImpl(logFiles, (Clock)this.clock, (Health)this.databaseHealth, (LogRotationMonitor)monitors.newMonitor(LogRotationMonitor.class, new String[0]));
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(logFiles, logRotation, transactionMetadataCache, transactionIdStore, (Health)this.databaseHealth));
        PhysicalLogicalTransactionStore logicalTransactionStore = new PhysicalLogicalTransactionStore(logFiles, transactionMetadataCache, logEntryReader, monitors, true);
        CheckPointThreshold threshold = CheckPointThreshold.createThreshold(config, this.clock, logPruning, logProvider);
        CheckPointerImpl checkPointer = new CheckPointerImpl(transactionIdStore, threshold, forceOperation, logPruning, appender, (Health)this.databaseHealth, logProvider, this.databaseTracer, this.ioLimiter, this.storeCopyCheckPointMutex);
        long recurringPeriod = threshold.checkFrequencyMillis();
        CheckPointScheduler checkPointScheduler = new CheckPointScheduler(checkPointer, this.ioLimiter, scheduler, recurringPeriod, (Health)this.databaseHealth);
        this.life.add((Lifecycle)checkPointer);
        this.life.add((Lifecycle)checkPointScheduler);
        return new DatabaseTransactionLogModule(logicalTransactionStore, logFiles, logRotation, checkPointer, appender);
    }

    private DatabaseKernelModule buildKernel(LogFiles logFiles, TransactionAppender appender, IndexingService indexingService, DatabaseSchemaState databaseSchemaState, LabelScanStore labelScanStore, StorageEngine storageEngine, TransactionIdStore transactionIdStore, AvailabilityGuard databaseAvailabilityGuard, SystemNanoClock clock, IndexStatisticsStore indexStatisticsStore, GraphDatabaseFacade facade, LeaseService leaseService) {
        AtomicReference<CpuClock> cpuClockRef = this.setupCpuClockAtomicReference();
        AtomicReference<HeapAllocation> heapAllocationRef = this.setupHeapAllocationAtomicReference();
        TransactionCommitProcess transactionCommitProcess = this.commitProcessFactory.create(appender, storageEngine, this.databaseConfig);
        Supplier<Kernel> kernelProvider = () -> this.kernelModule.kernelAPI();
        ConstraintIndexCreator constraintIndexCreator = new ConstraintIndexCreator(kernelProvider, indexingService, (LogProvider)this.internalLogProvider);
        DatabaseTransactionEventListeners databaseTransactionEventListeners = new DatabaseTransactionEventListeners(facade, this.transactionEventListeners, this.namedDatabaseId);
        KernelTransactions kernelTransactions = (KernelTransactions)this.life.add((Lifecycle)new KernelTransactions(this.databaseConfig, this.statementLocksFactory, constraintIndexCreator, transactionCommitProcess, databaseTransactionEventListeners, this.transactionStats, databaseAvailabilityGuard, storageEngine, this.globalProcedures, transactionIdStore, clock, cpuClockRef, heapAllocationRef, this.accessCapability, this.versionContextSupplier, this.collectionsFactorySupplier, this.constraintSemantics, databaseSchemaState, this.tokenHolders, this.getNamedDatabaseId(), indexingService, labelScanStore, indexStatisticsStore, this.databaseDependencies, this.databaseTracer, this.pageCursorTracerSupplier, this.lockTracer, leaseService));
        this.buildTransactionMonitor(kernelTransactions, this.databaseConfig);
        KernelImpl kernel = new KernelImpl(kernelTransactions, (Health)this.databaseHealth, this.transactionStats, this.globalProcedures, this.databaseConfig, storageEngine);
        this.life.add((Lifecycle)kernel);
        DatabaseFileListing fileListing = new DatabaseFileListing(this.databaseLayout, logFiles, labelScanStore, indexingService, storageEngine, this.idGeneratorFactory);
        this.databaseDependencies.satisfyDependency((Object)fileListing);
        return new DatabaseKernelModule(transactionCommitProcess, kernel, kernelTransactions, fileListing);
    }

    private AtomicReference<CpuClock> setupCpuClockAtomicReference() {
        AtomicReference<CpuClock> cpuClock = new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE);
        SettingChangeListener cpuClockUpdater = (before, after) -> {
            if (after.booleanValue()) {
                cpuClock.set(CpuClock.CPU_CLOCK);
            } else {
                cpuClock.set(CpuClock.NOT_AVAILABLE);
            }
        };
        cpuClockUpdater.accept(null, (Object)((Boolean)this.databaseConfig.get(GraphDatabaseSettings.track_query_cpu_time)));
        this.databaseConfig.addListener(GraphDatabaseSettings.track_query_cpu_time, cpuClockUpdater);
        return cpuClock;
    }

    private AtomicReference<HeapAllocation> setupHeapAllocationAtomicReference() {
        AtomicReference<HeapAllocation> heapAllocation = new AtomicReference<HeapAllocation>(HeapAllocation.NOT_AVAILABLE);
        SettingChangeListener heapAllocationUpdater = (before, after) -> {
            if (after.booleanValue()) {
                heapAllocation.set(HeapAllocation.HEAP_ALLOCATION);
            } else {
                heapAllocation.set(HeapAllocation.NOT_AVAILABLE);
            }
        };
        heapAllocationUpdater.accept(null, (Object)((Boolean)this.databaseConfig.get(GraphDatabaseSettings.track_query_allocation)));
        this.databaseConfig.addListener(GraphDatabaseSettings.track_query_allocation, heapAllocationUpdater);
        return heapAllocation;
    }

    private void buildTransactionMonitor(KernelTransactions kernelTransactions, Config config) {
        KernelTransactionMonitor kernelTransactionTimeoutMonitor = new KernelTransactionMonitor(kernelTransactions, this.clock, (LogService)this.databaseLogService);
        this.databaseDependencies.satisfyDependency((Object)kernelTransactionTimeoutMonitor);
        KernelTransactionMonitorScheduler transactionMonitorScheduler = new KernelTransactionMonitorScheduler(kernelTransactionTimeoutMonitor, this.scheduler, ((Duration)config.get(GraphDatabaseSettings.transaction_monitor_check_interval)).toMillis());
        this.life.add((Lifecycle)transactionMonitorScheduler);
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.eventListeners.databaseShutdown(this.namedDatabaseId.name());
        this.life.stop();
        this.awaitAllClosingTransactions();
        this.life.shutdown();
        this.started = false;
    }

    public void prepareToDrop() {
        this.prepareStop(Predicates.alwaysTrue());
        this.checkpointerLifecycle.setCheckpointOnShutdown(false);
    }

    public synchronized void drop() {
        if (this.started) {
            this.prepareToDrop();
            this.stop();
        }
        this.deleteDatabaseFiles(List.of(this.databaseLayout.databaseDirectory(), this.databaseLayout.getTransactionLogsDirectory()));
    }

    public synchronized void truncate() {
        File[] transactionLogs;
        boolean truncateStartedDatabase = this.started;
        List<File> filesToKeep = DatabaseFileHelper.filesToKeepOnTruncation(this.databaseLayout);
        File[] fileArray = transactionLogs = this.databaseDependencies != null ? ((LogFiles)this.databaseDependencies.resolveDependency(LogFiles.class)).logFiles() : new TransactionLogFilesHelper(this.fs, this.databaseLayout.getTransactionLogsDirectory()).getLogFiles();
        if (truncateStartedDatabase) {
            this.prepareStop(pagedFile -> !filesToKeep.contains(pagedFile.file()));
            this.stop();
        }
        List<File> filesToDelete = DatabaseFileHelper.filesToDeleteOnTruncation(filesToKeep, this.databaseLayout, transactionLogs);
        this.deleteDatabaseFiles(filesToDelete);
        if (truncateStartedDatabase) {
            this.start();
        }
    }

    private void deleteDatabaseFiles(List<File> files) {
        try {
            for (File fileToDelete : files) {
                FileSystemUtils.deleteFile((FileSystemAbstraction)this.fs, (File)fileToDelete);
            }
        }
        catch (IOException e) {
            ((DatabaseLog)this.internalLogProvider.getLog(Database.class)).error(String.format("Failed to delete database '%s' files.", this.namedDatabaseId.name()), (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    private void awaitAllClosingTransactions() {
        KernelTransactions kernelTransactions = this.kernelModule.kernelTransactions();
        kernelTransactions.terminateTransactions();
        while (kernelTransactions.haveClosingTransaction()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    public Config getConfig() {
        return this.databaseConfig;
    }

    public DatabaseLogService getLogService() {
        return this.databaseLogService;
    }

    public DatabaseLogProvider getInternalLogProvider() {
        return this.internalLogProvider;
    }

    public StoreId getStoreId() {
        return this.storageEngine.getStoreId();
    }

    public DatabaseLayout getDatabaseLayout() {
        return this.databaseLayout;
    }

    public Monitors getMonitors() {
        return this.databaseMonitors;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public QueryExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public Kernel getKernel() {
        return this.kernelModule.kernelAPI();
    }

    public ResourceIterator<StoreFileMetadata> listStoreFiles(boolean includeLogs) throws IOException {
        DatabaseFileListing.StoreFileListingBuilder fileListingBuilder = this.getDatabaseFileListing().builder();
        fileListingBuilder.excludeIdFiles();
        if (!includeLogs) {
            fileListingBuilder.excludeLogFiles();
        }
        return fileListingBuilder.build();
    }

    public DatabaseFileListing getDatabaseFileListing() {
        return this.kernelModule.fileListing();
    }

    public Dependencies getDependencyResolver() {
        return this.databaseDependencies;
    }

    public JobScheduler getScheduler() {
        return this.scheduler;
    }

    public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
        return this.storeCopyCheckPointMutex;
    }

    public NamedDatabaseId getNamedDatabaseId() {
        return this.namedDatabaseId;
    }

    public TokenHolders getTokenHolders() {
        return this.tokenHolders;
    }

    public DatabaseAvailabilityGuard getDatabaseAvailabilityGuard() {
        return this.databaseAvailabilityGuard;
    }

    public GraphDatabaseFacade getDatabaseFacade() {
        return this.databaseFacade;
    }

    public Health getDatabaseHealth() {
        return this.databaseHealth;
    }

    public VersionContextSupplier getVersionContextSupplier() {
        return this.versionContextSupplier;
    }

    private void prepareStop(Predicate<PagedFile> deleteFilePredicate) {
        this.databasePageCache.listExistingMappings().stream().filter(deleteFilePredicate).forEach(file -> file.setDeleteOnClose(true));
    }

    private long getAwaitActiveTransactionDeadlineMillis() {
        return ((Duration)this.databaseConfig.get(GraphDatabaseSettings.shutdown_transaction_end_timeout)).toMillis();
    }

    @VisibleForTesting
    public LifeSupport getLife() {
        return this.life;
    }

    public static Iterable<IndexDescriptor> initialSchemaRulesLoader(StorageEngine storageEngine) {
        return () -> {
            try (StorageReader reader = storageEngine.newReader();){
                Iterator iterator = Iterators.asList((Iterator)reader.indexesGetAll()).iterator();
                return iterator;
            }
        };
    }

    public boolean isStarted() {
        return this.started;
    }

    private static void safeStorageEngineClose(StorageEngine storageEngine) {
        if (storageEngine != null) {
            storageEngine.forceClose();
        }
    }

    private static void safeLifeShutdown(LifeSupport life) {
        if (life != null) {
            life.shutdown();
        }
    }
}

