/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.cursor.CursorValue;
import org.neo4j.cursor.RawCursor;

public class Cursors {
    private static Cursor<Object> EMPTY = new Cursor<Object>(){

        public boolean next() {
            return false;
        }

        public Object get() {
            throw new IllegalStateException("no elements");
        }

        public void close() {
        }
    };

    private Cursors() {
    }

    public static <T> Cursor<T> empty() {
        return EMPTY;
    }

    public static <T, EX extends Exception> RawCursor<T, EX> rawCursorOf(final Iterable<T> iterable) {
        return new RawCursor<T, EX>(){
            private CursorValue<T> current = new CursorValue();
            private Iterator<T> itr = iterable.iterator();

            public T get() {
                return this.current.get();
            }

            public boolean next() {
                if (this.itr.hasNext()) {
                    this.current.set(this.itr.next());
                    return true;
                }
                this.current.invalidate();
                return false;
            }

            public void close() {
                this.current.invalidate();
            }
        };
    }
}

