/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.HasChanges;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.Scan;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;

class DefaultNodeCursor
extends TraceableCursor
implements NodeCursor {
    Read read;
    HasChanges hasChanges = HasChanges.MAYBE;
    private LongIterator addedNodes;
    StorageNodeCursor storeCursor;
    private long currentAddedInTx;
    private long single;
    private AccessMode accessMode;
    private final CursorPool<DefaultNodeCursor> pool;

    DefaultNodeCursor(CursorPool<DefaultNodeCursor> pool, StorageNodeCursor storeCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
    }

    void scan(Read read) {
        this.storeCursor.scan();
        this.read = read;
        this.single = -1L;
        this.currentAddedInTx = -1L;
        this.hasChanges = HasChanges.MAYBE;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
        this.accessMode = read.ktx.securityContext().mode();
        if (this.tracer != null) {
            this.tracer.onAllNodesScan();
        }
    }

    boolean scanBatch(Read read, AllNodeScan scan, int sizeHint, LongIterator addedNodes, boolean hasChanges) {
        this.read = read;
        this.single = -1L;
        this.currentAddedInTx = -1L;
        this.hasChanges = hasChanges ? HasChanges.YES : HasChanges.NO;
        this.addedNodes = addedNodes;
        this.accessMode = read.ktx.securityContext().mode();
        boolean scanBatch = this.storeCursor.scanBatch((Scan)scan, sizeHint);
        return addedNodes.hasNext() || scanBatch;
    }

    void single(long reference, Read read) {
        this.storeCursor.single(reference);
        this.read = read;
        this.single = reference;
        this.currentAddedInTx = -1L;
        this.hasChanges = HasChanges.MAYBE;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
        this.accessMode = read.ktx.securityContext().mode();
    }

    public long nodeReference() {
        if (this.currentAddedInTx != -1L) {
            return this.currentAddedInTx;
        }
        return this.storeCursor.entityReference();
    }

    public LabelSet labels() {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.read.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        if (this.hasChanges()) {
            TransactionState txState = this.read.txState();
            long[] longs = this.storeCursor.labels();
            LongHashSet labels = new LongHashSet();
            for (long labelToken : longs) {
                labels.add(labelToken);
            }
            return Labels.from((LongSet)txState.augmentLabels((MutableLongSet)labels, txState.getNodeState(this.storeCursor.entityReference())));
        }
        return Labels.from(this.storeCursor.labels());
    }

    public LabelSet labelsIgnoringTxStateSetRemove() {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.read.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        return Labels.from(this.storeCursor.labels());
    }

    public boolean hasLabel(int label) {
        if (this.hasChanges()) {
            TransactionState txState = this.read.txState();
            LongDiffSets diffSets = txState.nodeStateLabelDiffSets(this.nodeReference());
            if (diffSets.getAdded().contains((long)label)) {
                return true;
            }
            if (diffSets.getRemoved().contains((long)label)) {
                return false;
            }
        }
        return this.storeCursor.hasLabel(label);
    }

    public void relationships(RelationshipGroupCursor cursor) {
        ((DefaultRelationshipGroupCursor)cursor).init(this.nodeReference(), this.relationshipGroupReferenceWithoutFlags(), this.isDense(), this.read);
    }

    public void allRelationships(RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this.nodeReference(), this.allRelationshipsReferenceWithoutFlags(), this.isDense(), this.read);
    }

    public void properties(PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(this.nodeReference(), this.propertiesReference(), this.read, this.read);
    }

    public long relationshipGroupReference() {
        long reference = this.relationshipGroupReferenceWithoutFlags();
        return this.isDense() ? RelationshipReferenceEncoding.encodeDense(reference) : reference;
    }

    private long relationshipGroupReferenceWithoutFlags() {
        return this.currentAddedInTx != -1L ? -1L : this.storeCursor.relationshipGroupReference();
    }

    public long allRelationshipsReference() {
        long reference = this.allRelationshipsReferenceWithoutFlags();
        return this.isDense() ? RelationshipReferenceEncoding.encodeDense(reference) : reference;
    }

    private long allRelationshipsReferenceWithoutFlags() {
        return this.currentAddedInTx != -1L ? -1L : this.storeCursor.allRelationshipsReference();
    }

    public long propertiesReference() {
        return this.currentAddedInTx != -1L ? -1L : this.storeCursor.propertiesReference();
    }

    public boolean isDense() {
        return this.currentAddedInTx == -1L && this.storeCursor.isDense();
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            if (this.addedNodes.hasNext()) {
                this.currentAddedInTx = this.addedNodes.next();
                if (this.tracer != null) {
                    this.tracer.onNode(this.nodeReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (this.storeCursor.next()) {
            boolean skip = hasChanges && this.read.txState().nodeIsDeletedInThisTx(this.storeCursor.entityReference());
            if (skip || !this.allowsTraverse()) continue;
            if (this.tracer != null) {
                this.tracer.onNode(this.nodeReference());
            }
            return true;
        }
        return false;
    }

    boolean allowsTraverse() {
        return this.accessMode.allowsTraverseAllLabels() || this.accessMode.allowsTraverseNode(this.storeCursor.labels());
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.hasChanges = HasChanges.MAYBE;
            this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
            this.storeCursor.reset();
            this.accessMode = null;
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.read == null;
    }

    boolean hasChanges() {
        switch (this.hasChanges) {
            case MAYBE: {
                boolean changes = this.read.hasTxStateWithChanges();
                if (changes) {
                    this.addedNodes = this.single != -1L ? (this.read.txState().nodeIsAddedInThisTx(this.single) ? LongSets.immutable.of(this.single).longIterator() : ImmutableEmptyLongIterator.INSTANCE) : this.read.txState().addedAndRemovedNodes().getAdded().freeze().longIterator();
                    this.hasChanges = HasChanges.YES;
                } else {
                    this.hasChanges = HasChanges.NO;
                }
                return changes;
            }
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        throw new IllegalStateException("Style guide, why are you making me do this");
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeCursor[closed state]";
        }
        return "NodeCursor[id=" + this.nodeReference() + ", " + this.storeCursor.toString() + "]";
    }

    void release() {
        this.storeCursor.close();
    }
}

