/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;

class RecoveryStoreFileHelper {
    private RecoveryStoreFileHelper() {
    }

    static boolean allIdFilesExist(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem) {
        return databaseLayout.idFiles().stream().allMatch(arg_0 -> ((FileSystemAbstraction)fileSystem).fileExists(arg_0));
    }

    static StoreFilesInfo checkStoreFiles(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem) {
        Set storeFiles = databaseLayout.storeFiles();
        storeFiles.remove(databaseLayout.countStore());
        storeFiles.remove(databaseLayout.indexStatisticsStore());
        storeFiles.remove(databaseLayout.labelScanStore());
        return RecoveryStoreFileHelper.collectStoreFilesInfo(fileSystem, storeFiles);
    }

    private static StoreFilesInfo collectStoreFilesInfo(FileSystemAbstraction fileSystem, Set<File> storeFiles) {
        List<File> missingFiles = storeFiles.stream().filter(file -> !fileSystem.fileExists(file)).collect(Collectors.toList());
        return new StoreFilesInfo(missingFiles);
    }

    static class StoreFilesInfo {
        private final List<File> missingStoreFiles;

        StoreFilesInfo(List<File> missingFiles) {
            this.missingStoreFiles = missingFiles;
        }

        List<File> getMissingStoreFiles() {
            return this.missingStoreFiles;
        }

        boolean allFilesPresent() {
            return this.missingStoreFiles.isEmpty();
        }
    }
}

