/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.storemigration.LegacyDatabaseLayout;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionMetaDataStore;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;

public class LogsUpgrader {
    private final FileSystemAbstraction fs;
    private final StorageEngineFactory storageEngineFactory;
    private final DatabaseLayout databaseLayout;
    private final PageCache pageCache;
    private final LegacyTransactionLogsLocator legacyLogsLocator;
    private final Config config;
    private final DependencyResolver dependencyResolver;

    public LogsUpgrader(FileSystemAbstraction fs, StorageEngineFactory storageEngineFactory, DatabaseLayout databaseLayout, PageCache pageCache, LegacyTransactionLogsLocator legacyLogsLocator, Config config, DependencyResolver dependencyResolver) {
        this.fs = fs;
        this.storageEngineFactory = storageEngineFactory;
        this.databaseLayout = databaseLayout;
        this.pageCache = pageCache;
        this.legacyLogsLocator = legacyLogsLocator;
        this.config = config;
        this.dependencyResolver = dependencyResolver;
    }

    public void assertCleanlyShutDownByCheckPoint(DatabaseLayout layout) {
        Throwable suppressibleException = null;
        try {
            DatabaseLayout oldDatabaseLayout = this.buildLegacyLogsLayout(layout);
            LogTailScanner logTailScanner = this.buildLogTailScanner(oldDatabaseLayout);
            LogVersionUpgradeChecker.check(logTailScanner, this.config);
            LogTailScanner.LogTailInformation tail = logTailScanner.getTailInformation();
            if (!tail.isRecoveryRequired()) {
                return;
            }
            if (tail.logsMissing()) {
                logTailScanner = this.buildLogTailScanner(layout);
                LogVersionUpgradeChecker.check(logTailScanner, this.config);
                tail = logTailScanner.getTailInformation();
                if (!tail.isRecoveryRequired()) {
                    return;
                }
                if (tail.logsMissing() && !((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            suppressibleException = throwable;
        }
        StoreUpgrader.DatabaseNotCleanlyShutDownException exception = new StoreUpgrader.DatabaseNotCleanlyShutDownException();
        if (suppressibleException != null) {
            exception.addSuppressed(suppressibleException);
        }
        throw exception;
    }

    private DatabaseLayout buildLegacyLogsLayout(DatabaseLayout databaseLayout) {
        return new LegacyDatabaseLayout(databaseLayout.getNeo4jLayout(), databaseLayout.getDatabaseName(), this.legacyLogsLocator);
    }

    private LogTailScanner buildLogTailScanner(DatabaseLayout layout) {
        LogFiles logFiles;
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        try {
            logFiles = LogFilesBuilder.builder(layout, this.fs).withLogEntryReader((LogEntryReader)logEntryReader).withConfig(this.config).withDependencies(this.dependencyResolver).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Monitors monitors = (Monitors)this.dependencyResolver.resolveDependency(Monitors.class);
        return new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, monitors, (Boolean)this.config.get(GraphDatabaseSettings.fail_on_corrupted_log_files));
    }

    public void upgrade(DatabaseLayout layout) {
        try (TransactionMetaDataStore store = this.getMetaDataStore();){
            TransactionLogInitializer logInitializer = new TransactionLogInitializer(this.fs, store);
            File transactionLogsDirectory = layout.getTransactionLogsDirectory();
            File legacyLogsDirectory = this.legacyLogsLocator.getTransactionLogsDirectory();
            boolean filesNeedsToMove = !transactionLogsDirectory.equals(legacyLogsDirectory);
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(legacyLogsDirectory, this.fs).build();
            File[] legacyFiles = logFiles.logFiles();
            if (legacyFiles != null && legacyFiles.length > 0) {
                if (filesNeedsToMove) {
                    for (File legacyFile : legacyFiles) {
                        this.fs.copyFile(legacyFile, new File(transactionLogsDirectory, legacyFile.getName()), FileSystemAbstraction.EMPTY_COPY_OPTIONS);
                    }
                }
                logInitializer.initializeExistingLogFiles(layout, transactionLogsDirectory);
                if (filesNeedsToMove) {
                    for (File legacyFile : legacyFiles) {
                        this.fs.deleteFile(legacyFile);
                    }
                }
            } else {
                logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(transactionLogsDirectory, this.fs).build();
                legacyFiles = logFiles.logFiles();
                if (legacyFiles != null && legacyFiles.length > 0) {
                    logInitializer.initializeExistingLogFiles(layout, transactionLogsDirectory);
                } else {
                    if (((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                        throw new UpgradeNotAllowedException();
                    }
                    logInitializer.initializeEmptyLogFile(layout, transactionLogsDirectory);
                }
            }
        }
        catch (Exception exception) {
            throw new StoreUpgrader.TransactionLogsRelocationException("Failure on attempt to move transaction logs into new location.", exception);
        }
    }

    private TransactionMetaDataStore getMetaDataStore() throws IOException {
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (Object)true);
        return this.storageEngineFactory.transactionMetaDataStore(this.fs, this.databaseLayout, readOnlyConfig, this.pageCache);
    }
}

