/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.Status;

public class NoSuchConstraintException
extends SchemaKernelException {
    private final SchemaDescriptorSupplier constraint;
    private final String name;
    private static final String message = "No such constraint %s.";

    public NoSuchConstraintException(SchemaDescriptorSupplier constraint, TokenNameLookup lookup) {
        super((Status)Status.Schema.ConstraintNotFound, String.format(message, constraint.userDescription(lookup)));
        this.constraint = constraint;
        this.name = "";
    }

    public NoSuchConstraintException(String name) {
        super((Status)Status.Schema.ConstraintNotFound, String.format(message, name));
        this.constraint = null;
        this.name = name;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        if (this.constraint == null) {
            return String.format(message, this.name);
        }
        return String.format(message, this.constraint.userDescription(tokenNameLookup));
    }
}

