/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.memory.BufferScope;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.storageengine.api.LogVersionRepository;

class TransactionLogFile
extends LifecycleAdapter
implements LogFile {
    private final AtomicLong rotateAtSize;
    private final LogFiles logFiles;
    private final TransactionLogFilesContext context;
    private final LogVersionBridge readerLogVersionBridge;
    private BufferScope bufferScope;
    private PositionAwarePhysicalFlushableChecksumChannel writer;
    private LogVersionRepository logVersionRepository;
    private volatile PhysicalLogVersionedStoreChannel channel;

    TransactionLogFile(LogFiles logFiles, TransactionLogFilesContext context) {
        this.rotateAtSize = context.getRotationThreshold();
        this.context = context;
        this.logFiles = logFiles;
        this.readerLogVersionBridge = new ReaderLogVersionBridge(logFiles);
    }

    public void init() throws IOException {
        this.logVersionRepository = this.context.getLogVersionRepository();
    }

    public void start() throws IOException {
        long currentLogVersion = this.logVersionRepository.getCurrentLogVersion();
        this.channel = this.logFiles.createLogChannelForVersion(currentLogVersion, this.context::getLastCommittedTransactionId);
        this.seekChannelPosition(currentLogVersion);
        this.bufferScope = new BufferScope(TransactionLogFile.calculateLogBufferSize());
        this.writer = new PositionAwarePhysicalFlushableChecksumChannel(this.channel, this.bufferScope.buffer);
    }

    private void seekChannelPosition(long currentLogVersion) throws IOException {
        this.scrollToTheLastClosedTxPosition(currentLogVersion);
        LogPosition position = this.scrollOverCheckpointRecords();
        this.channel.position(position.getByteOffset());
    }

    private LogPosition scrollOverCheckpointRecords() throws IOException {
        LogEntry entry;
        ReadAheadLogChannel readAheadLogChannel = new ReadAheadLogChannel(this.channel);
        LogEntryReader logEntryReader = this.context.getLogEntryReader();
        while ((entry = logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)readAheadLogChannel)) != null) {
        }
        return logEntryReader.lastPosition();
    }

    private void scrollToTheLastClosedTxPosition(long currentLogVersion) throws IOException {
        LogPosition logPosition = this.context.getLastClosedTransactionPosition();
        long lastTxOffset = logPosition.getByteOffset();
        long lastTxLogVersion = logPosition.getLogVersion();
        long headerSize = this.logFiles.extractHeader(currentLogVersion).getStartPosition().getByteOffset();
        if (lastTxOffset < headerSize || this.channel.size() < lastTxOffset) {
            return;
        }
        if (lastTxLogVersion == currentLogVersion) {
            this.channel.position(lastTxOffset);
        }
    }

    public void shutdown() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writer, this.bufferScope});
    }

    @Override
    public boolean rotationNeeded() {
        return this.channel.position() >= this.rotateAtSize.get();
    }

    @Override
    public synchronized File rotate() throws IOException {
        this.channel = this.rotate(this.channel);
        this.writer.setChannel(this.channel);
        return this.channel.getFile();
    }

    private PhysicalLogVersionedStoreChannel rotate(LogVersionedStoreChannel currentLog) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetVersion();
        this.writer.prepareForFlush().flush();
        currentLog.truncate(currentLog.position());
        PhysicalLogVersionedStoreChannel newLog = this.logFiles.createLogChannelForVersion(newLogVersion, this.context::committingTransactionId);
        currentLog.close();
        return newLog;
    }

    @Override
    public FlushablePositionAwareChecksumChannel getWriter() {
        return this.writer;
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position) throws IOException {
        return this.getReader(position, this.readerLogVersionBridge);
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position, LogVersionBridge logVersionBridge) throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = this.logFiles.openForVersion(position.getLogVersion());
        logChannel.position(position.getByteOffset());
        return new ReadAheadLogChannel(logChannel, logVersionBridge);
    }

    @Override
    public void accept(LogFile.LogFileVisitor visitor, LogPosition startingFromPosition) throws IOException {
        try (ReadableLogChannel reader = this.getReader(startingFromPosition);){
            visitor.visit((ReadableClosablePositionAwareChecksumChannel)reader);
        }
    }

    private static int calculateLogBufferSize() {
        return (int)ByteUnit.kibiBytes((long)(Math.min(Runtime.getRuntime().availableProcessors() / 4 + 1, 8) * 512));
    }
}

