/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexConfig;
import org.neo4j.kernel.impl.storemigration.IndexConfigExtractorUtil;
import org.neo4j.logging.Log;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;

final class GenericConfigExtractor {
    private GenericConfigExtractor() {
    }

    static IndexConfig indexConfigFromGenericFile(FileSystemAbstraction fs, PageCache pageCache, File genericFile, Log log) throws IOException {
        HashMap<String, Value> indexConfig = new HashMap<String, Value>();
        if (fs.fileExists(genericFile)) {
            try {
                GBPTree.readHeader((PageCache)pageCache, (File)genericFile, (Header.Reader)new GenericConfig(indexConfig, genericFile, log));
            }
            catch (MetadataMismatchException e) {
                IndexConfigExtractorUtil.logExtractionFailure("Index meta data is corrupt and can not be parsed.", log, genericFile);
            }
        } else {
            IndexConfigExtractorUtil.logExtractionFailure("Index file does not exists.", log, genericFile);
        }
        return IndexConfig.with(indexConfig);
    }

    private static class GenericConfig
    implements Header.Reader {
        private static final byte VERSION = 0;
        private static final byte BYTE_FAILED = 0;
        private final Map<String, Value> indexConfig;
        private final File indexFile;
        private final Log log;

        GenericConfig(Map<String, Value> indexConfig, File indexFile, Log log) {
            this.indexConfig = indexConfig;
            this.indexFile = indexFile;
            this.log = log;
        }

        public void read(ByteBuffer headerBytes) {
            byte state = headerBytes.get();
            if (state != 0) {
                byte version = headerBytes.get();
                if (version != 0) {
                    throw new UnsupportedOperationException("Invalid crs settings header version " + version + ", was expecting 0");
                }
                int count = headerBytes.getInt();
                for (int i = 0; i < count; ++i) {
                    this.readNext(headerBytes);
                }
            } else {
                IndexConfigExtractorUtil.logExtractionFailure("Index is in FAILED state.", this.log, this.indexFile);
            }
        }

        private void readNext(ByteBuffer headerBytes) {
            int tableId = headerBytes.get() & 0xFF;
            int code = headerBytes.getInt();
            int maxLevels = headerBytes.getShort() & 0xFFFF;
            int dimensions = headerBytes.getShort() & 0xFFFF;
            double[] min = new double[dimensions];
            double[] max = new double[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                min[i] = Double.longBitsToDouble(headerBytes.getLong());
                max[i] = Double.longBitsToDouble(headerBytes.getLong());
            }
            CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)tableId, (int)code);
            SpatialIndexConfig.addSpatialConfig(this.indexConfig, crs, min, max);
        }
    }
}

