/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.RecoveryStartInformation;

public class RecoveryStartInformationProvider
implements ThrowingSupplier<RecoveryStartInformation, IOException> {
    public static final Monitor NO_MONITOR = new Monitor(){};
    private final LogTailScanner logTailScanner;
    private final LogFiles logFiles;
    private final Monitor monitor;

    public RecoveryStartInformationProvider(LogTailScanner logTailScanner, LogFiles logFiles, Monitor monitor) {
        this.logTailScanner = logTailScanner;
        this.logFiles = logFiles;
        this.monitor = monitor;
    }

    public RecoveryStartInformation get() {
        LogTailScanner.LogTailInformation logTailInformation = this.logTailScanner.getTailInformation();
        CheckPoint lastCheckPoint = logTailInformation.lastCheckPoint;
        long txIdAfterLastCheckPoint = logTailInformation.firstTxIdAfterLastCheckPoint;
        if (!logTailInformation.isRecoveryRequired()) {
            this.monitor.noCommitsAfterLastCheckPoint(lastCheckPoint != null ? lastCheckPoint.getLogPosition() : null);
            return RecoveryStartInformation.NO_RECOVERY_REQUIRED;
        }
        if (logTailInformation.logsMissing()) {
            return RecoveryStartInformation.MISSING_LOGS;
        }
        if (logTailInformation.commitsAfterLastCheckpoint()) {
            if (lastCheckPoint == null) {
                if (logTailInformation.oldestLogVersionFound != 0L) {
                    long fromLogVersion = Math.max(0L, logTailInformation.oldestLogVersionFound);
                    throw new UnderlyingStorageException("No check point found in any log file from version " + fromLogVersion + " to " + logTailInformation.currentLogVersion);
                }
                this.monitor.noCheckPointFound();
                LogPosition position = this.tryExtractHeaderSize();
                return RecoveryStartInformationProvider.createRecoveryInformation(position, txIdAfterLastCheckPoint);
            }
            LogPosition checkpointLogPosition = lastCheckPoint.getLogPosition();
            this.monitor.commitsAfterLastCheckPoint(checkpointLogPosition, txIdAfterLastCheckPoint);
            return RecoveryStartInformationProvider.createRecoveryInformation(lastCheckPoint.getLogPosition(), txIdAfterLastCheckPoint);
        }
        throw new UnderlyingStorageException("Fail to determine recovery information Log tail info: " + logTailInformation);
    }

    private LogPosition tryExtractHeaderSize() {
        try {
            return this.logFiles.extractHeader(0L).getStartPosition();
        }
        catch (IOException e) {
            this.monitor.failToExtractInitialFileHeader(e);
            return new LogPosition(0L, 64L);
        }
    }

    private static RecoveryStartInformation createRecoveryInformation(LogPosition logPosition, long firstTxId) {
        return new RecoveryStartInformation(logPosition, firstTxId);
    }

    public static interface Monitor {
        default public void noCommitsAfterLastCheckPoint(LogPosition logPosition) {
        }

        default public void commitsAfterLastCheckPoint(LogPosition logPosition, long firstTxIdAfterLastCheckPoint) {
        }

        default public void noCheckPointFound() {
        }

        default public void failToExtractInitialFileHeader(Exception e) {
        }
    }
}

