/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageReader;

public class DefaultPooledCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;
    private DefaultNodeCursor nodeCursor;
    private FullAccessNodeCursor fullAccessNodeCursor;
    private DefaultRelationshipScanCursor relationshipScanCursor;
    private FullAccessRelationshipScanCursor fullAccessRelationshipScanCursor;
    private DefaultRelationshipTraversalCursor relationshipTraversalCursor;
    private DefaultPropertyCursor propertyCursor;
    private FullAccessPropertyCursor fullAccessPropertyCursor;
    private DefaultRelationshipGroupCursor relationshipGroupCursor;
    private DefaultNodeValueIndexCursor nodeValueIndexCursor;
    private DefaultNodeLabelIndexCursor nodeLabelIndexCursor;
    private DefaultRelationshipIndexCursor relationshipIndexCursor;

    public DefaultPooledCursors(StorageReader storageReader) {
        super(new ArrayList<DefaultCursors.CloseableStacktrace>());
        this.storageReader = storageReader;
    }

    public DefaultNodeCursor allocateNodeCursor() {
        if (this.nodeCursor == null) {
            return this.trace(new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor()));
        }
        try {
            DefaultNodeCursor defaultNodeCursor = this.nodeCursor;
            return defaultNodeCursor;
        }
        finally {
            this.nodeCursor = null;
        }
    }

    private void accept(DefaultNodeCursor cursor) {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
        }
        this.nodeCursor = cursor;
    }

    public FullAccessNodeCursor allocateFullAccessNodeCursor() {
        if (this.fullAccessNodeCursor == null) {
            return this.trace(new FullAccessNodeCursor(this::acceptFullAccess, this.storageReader.allocateNodeCursor()));
        }
        try {
            FullAccessNodeCursor fullAccessNodeCursor = this.fullAccessNodeCursor;
            return fullAccessNodeCursor;
        }
        finally {
            this.fullAccessNodeCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeCursor cursor) {
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
        }
        this.fullAccessNodeCursor = (FullAccessNodeCursor)cursor;
    }

    public DefaultRelationshipScanCursor allocateRelationshipScanCursor() {
        if (this.relationshipScanCursor == null) {
            return this.trace(new DefaultRelationshipScanCursor(this::accept, this.storageReader.allocateRelationshipScanCursor()));
        }
        try {
            DefaultRelationshipScanCursor defaultRelationshipScanCursor = this.relationshipScanCursor;
            return defaultRelationshipScanCursor;
        }
        finally {
            this.relationshipScanCursor = null;
        }
    }

    private void accept(DefaultRelationshipScanCursor cursor) {
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
        }
        this.relationshipScanCursor = cursor;
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor() {
        if (this.fullAccessRelationshipScanCursor == null) {
            return this.trace(new FullAccessRelationshipScanCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipScanCursor()));
        }
        try {
            FullAccessRelationshipScanCursor fullAccessRelationshipScanCursor = this.fullAccessRelationshipScanCursor;
            return fullAccessRelationshipScanCursor;
        }
        finally {
            this.fullAccessRelationshipScanCursor = null;
        }
    }

    private void acceptFullAccess(DefaultRelationshipScanCursor cursor) {
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
        }
        this.fullAccessRelationshipScanCursor = (FullAccessRelationshipScanCursor)cursor;
    }

    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor() {
        if (this.relationshipTraversalCursor == null) {
            return this.trace(new DefaultRelationshipTraversalCursor(this::accept, this.storageReader.allocateRelationshipTraversalCursor()));
        }
        try {
            DefaultRelationshipTraversalCursor defaultRelationshipTraversalCursor = this.relationshipTraversalCursor;
            return defaultRelationshipTraversalCursor;
        }
        finally {
            this.relationshipTraversalCursor = null;
        }
    }

    void accept(DefaultRelationshipTraversalCursor cursor) {
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
        }
        this.relationshipTraversalCursor = cursor;
    }

    public DefaultPropertyCursor allocatePropertyCursor() {
        if (this.propertyCursor == null) {
            return this.trace(new DefaultPropertyCursor(this::accept, this.storageReader.allocatePropertyCursor()));
        }
        try {
            DefaultPropertyCursor defaultPropertyCursor = this.propertyCursor;
            return defaultPropertyCursor;
        }
        finally {
            this.propertyCursor = null;
        }
    }

    private void accept(DefaultPropertyCursor cursor) {
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
        }
        this.propertyCursor = cursor;
    }

    public FullAccessPropertyCursor allocateFullAccessPropertyCursor() {
        if (this.fullAccessPropertyCursor == null) {
            return this.trace(new FullAccessPropertyCursor(this::acceptFullAccess, this.storageReader.allocatePropertyCursor()));
        }
        try {
            FullAccessPropertyCursor fullAccessPropertyCursor = this.fullAccessPropertyCursor;
            return fullAccessPropertyCursor;
        }
        finally {
            this.fullAccessPropertyCursor = null;
        }
    }

    private void acceptFullAccess(DefaultPropertyCursor cursor) {
        if (this.fullAccessPropertyCursor != null) {
            this.fullAccessPropertyCursor.release();
        }
        this.fullAccessPropertyCursor = (FullAccessPropertyCursor)cursor;
    }

    public DefaultRelationshipGroupCursor allocateRelationshipGroupCursor() {
        if (this.relationshipGroupCursor == null) {
            return this.trace(new DefaultRelationshipGroupCursor(this::accept, this.storageReader.allocateRelationshipGroupCursor()));
        }
        try {
            DefaultRelationshipGroupCursor defaultRelationshipGroupCursor = this.relationshipGroupCursor;
            return defaultRelationshipGroupCursor;
        }
        finally {
            this.relationshipGroupCursor = null;
        }
    }

    private void accept(DefaultRelationshipGroupCursor cursor) {
        if (this.relationshipGroupCursor != null) {
            this.relationshipGroupCursor.release();
        }
        this.relationshipGroupCursor = cursor;
    }

    public DefaultNodeValueIndexCursor allocateNodeValueIndexCursor() {
        if (this.nodeValueIndexCursor == null) {
            return this.trace(new DefaultNodeValueIndexCursor(this::accept));
        }
        try {
            DefaultNodeValueIndexCursor defaultNodeValueIndexCursor = this.nodeValueIndexCursor;
            return defaultNodeValueIndexCursor;
        }
        finally {
            this.nodeValueIndexCursor = null;
        }
    }

    private void accept(DefaultNodeValueIndexCursor cursor) {
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
        }
        this.nodeValueIndexCursor = cursor;
    }

    public DefaultNodeLabelIndexCursor allocateNodeLabelIndexCursor() {
        if (this.nodeLabelIndexCursor == null) {
            return this.trace(new DefaultNodeLabelIndexCursor(this::accept));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = this.nodeLabelIndexCursor;
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.nodeLabelIndexCursor = null;
        }
    }

    private void accept(DefaultNodeLabelIndexCursor cursor) {
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
        }
        this.nodeLabelIndexCursor = cursor;
    }

    public RelationshipIndexCursor allocateRelationshipIndexCursor() {
        if (this.relationshipIndexCursor == null) {
            return this.trace(new DefaultRelationshipIndexCursor(this::accept));
        }
        try {
            DefaultRelationshipIndexCursor defaultRelationshipIndexCursor = this.relationshipIndexCursor;
            return defaultRelationshipIndexCursor;
        }
        finally {
            this.relationshipIndexCursor = null;
        }
    }

    private void accept(DefaultRelationshipIndexCursor cursor) {
        if (this.relationshipIndexCursor != null) {
            this.relationshipIndexCursor.release();
        }
        this.relationshipIndexCursor = cursor;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
            this.nodeCursor = null;
        }
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
            this.fullAccessNodeCursor = null;
        }
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
            this.relationshipScanCursor = null;
        }
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
            this.fullAccessRelationshipScanCursor = null;
        }
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
            this.relationshipTraversalCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
            this.propertyCursor = null;
        }
        if (this.fullAccessPropertyCursor != null) {
            this.fullAccessPropertyCursor.release();
            this.fullAccessPropertyCursor = null;
        }
        if (this.relationshipGroupCursor != null) {
            this.relationshipGroupCursor.release();
            this.relationshipGroupCursor = null;
        }
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
            this.nodeValueIndexCursor = null;
        }
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
            this.nodeLabelIndexCursor = null;
        }
        if (this.relationshipIndexCursor != null) {
            this.relationshipIndexCursor.release();
            this.relationshipIndexCursor = null;
        }
    }
}

