/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.Function;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexLimitation;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.values.storable.ValueCategory;

public class FusionIndexCapability
implements IndexCapability {
    private static final Function<ValueCategory, ValueCategory> categoryOf = vc -> vc;
    private final SlotSelector slotSelector;
    private final InstanceSelector<IndexCapability> instanceSelector;
    private final IndexLimitation[] limitations;

    FusionIndexCapability(SlotSelector slotSelector, InstanceSelector<IndexCapability> instanceSelector) {
        this.slotSelector = slotSelector;
        this.instanceSelector = instanceSelector;
        this.limitations = this.buildLimitations(slotSelector);
    }

    private IndexLimitation[] buildLimitations(SlotSelector slotSelector) {
        IndexSlot slot = slotSelector.selectSlot(new ValueCategory[]{ValueCategory.TEXT}, categoryOf);
        if (slot != IndexSlot.LUCENE) {
            return new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS};
        }
        return new IndexLimitation[0];
    }

    public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
        IndexSlot slot = this.slotSelector.selectSlot(valueCategories, categoryOf);
        if (slot == null) {
            return IndexCapability.ORDER_NONE;
        }
        return this.instanceSelector.select(slot).orderCapability(valueCategories);
    }

    public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
        IndexSlot slot = this.slotSelector.selectSlot(valueCategories, categoryOf);
        if (slot == null) {
            return IndexValueCapability.PARTIAL;
        }
        return this.instanceSelector.select(slot).valueCapability(valueCategories);
    }

    public IndexLimitation[] limitations() {
        return this.limitations;
    }
}

