/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class IndexSpecificSpaceFillingCurveSettings {
    private final ImmutableMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> specificIndexConfigCache;

    public IndexSpecificSpaceFillingCurveSettings(Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> specificIndexConfigCache) {
        this.specificIndexConfigCache = Maps.immutable.withAll(specificIndexConfigCache);
    }

    public static IndexSpecificSpaceFillingCurveSettings fromConfig(Config config) {
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> specificIndexConfigCache = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        ConfiguredSpaceFillingCurveSettingsCache configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            specificIndexConfigCache.put(crs, configuredSettings.forCRS(crs));
        }
        return new IndexSpecificSpaceFillingCurveSettings(specificIndexConfigCache);
    }

    public SpaceFillingCurve forCrs(int crsTableId, int crsCodePoint) {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)crsTableId, (int)crsCodePoint);
        return this.forCrs(crs);
    }

    public SpaceFillingCurve forCrs(CoordinateReferenceSystem crs) {
        SpaceFillingCurveSettings specificSetting = (SpaceFillingCurveSettings)this.specificIndexConfigCache.get((Object)crs);
        if (specificSetting != null) {
            return specificSetting.curve();
        }
        throw new IllegalStateException("Index does not have any settings for coordinate reference system " + crs);
    }

    public void visitIndexSpecificSettings(SettingVisitor visitor) {
        visitor.count(this.specificIndexConfigCache.size());
        for (CoordinateReferenceSystem crs : this.specificIndexConfigCache.keysView()) {
            visitor.visit(crs, (SpaceFillingCurveSettings)this.specificIndexConfigCache.get((Object)crs));
        }
    }

    public static interface SettingVisitor {
        public void count(int var1);

        public void visit(CoordinateReferenceSystem var1, SpaceFillingCurveSettings var2);
    }
}

